/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.trims;

import de.julianweinelt.ubm.UBM;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class TrimColorHelper {
    private static final HashMap<String, ResourceLocation> textureCache = new HashMap();

    public static ResourceLocation createColoredTrim(ResourceLocation location, Color[] palette) {
        String path = location.func_110623_a();
        return TrimColorHelper.createColoredTrim(path, palette);
    }

    public static ResourceLocation createColoredTrim(String overlayPath, Color[] palette) {
        String cacheKey = overlayPath + "-" + System.identityHashCode(palette);
        if (textureCache.containsKey(cacheKey)) {
            return textureCache.get(cacheKey);
        }
        HashMap<Integer, Integer> paletteIndex = TrimColorHelper.extractGrayLevels(overlayPath);
        try {
            BufferedImage overlay = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("ubm", overlayPath)).func_110527_b());
            BufferedImage colored = new BufferedImage(overlay.getWidth(), overlay.getHeight(), 2);
            for (int x = 0; x < overlay.getWidth(); ++x) {
                for (int y = 0; y < overlay.getHeight(); ++y) {
                    int rgb = overlay.getRGB(x, y);
                    if (new Color(rgb).equals(Color.BLACK)) {
                        colored.setRGB(x, y, 0);
                        continue;
                    }
                    Color color = paletteIndex.size() == 8 ? palette[palette.length - 1 - paletteIndex.get(rgb)] : palette[paletteIndex.get(rgb)];
                    colored.setRGB(x, y, color.getRGB());
                }
            }
            DynamicTexture dynTex = new DynamicTexture(colored);
            ResourceLocation location = Minecraft.func_71410_x().func_110434_K().func_110578_a("trim_colored", dynTex);
            textureCache.put(cacheKey, location);
            try {
                File outFile = new File(UBM.configDir, overlayPath.contains("legg") ? "leg_" : "ottest.png");
                ImageIO.write((RenderedImage)colored, "PNG", outFile);
                System.out.println("Textur gespeichert: " + outFile.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return location;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap<Integer, Integer> extractGrayLevels(String texturePath) {
        HashMap<Integer, Integer> grayLevels = new HashMap<Integer, Integer>();
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("ubm", texturePath)).func_110527_b());
            int currentLevel = 0;
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    int argb = image.getRGB(x, y);
                    int alpha = argb >> 24 & 0xFF;
                    if (alpha == 0 || grayLevels.containsKey(argb)) continue;
                    grayLevels.put(argb, currentLevel);
                    ++currentLevel;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return grayLevels;
    }

    public static Color[] extractPalette(String texturePath) {
        Color[] palette = new Color[8];
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("ubm", texturePath)).func_110527_b());
            for (int x = 0; x < image.getWidth(); ++x) {
                int argb = image.getRGB(x, 0);
                int alpha = argb >> 24 & 0xFF;
                if (alpha == 0) continue;
                if (x < 8) {
                    palette[x] = new Color(argb);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return palette;
        }
        return palette;
    }
}

