/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.worldgen;

import de.julianweinelt.ubm.worldgen.BiomeGroupsModern;
import javax.annotation.Nonnull;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class ClimateLayerModern
extends GenLayer {
    public ClimateLayerModern(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
    }

    @Nonnull
    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] parentInts = this.field_75909_a.func_75904_a(areaX, areaY, areaWidth, areaHeight);
        int[] dest = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int y = 0; y < areaHeight; ++y) {
            for (int x = 0; x < areaWidth; ++x) {
                Biome chosen;
                int index = x + y * areaWidth;
                int parentVal = parentInts[index];
                this.func_75903_a(x + areaX, y + areaY);
                if (parentVal == Biome.func_185362_a((Biome)Biomes.field_76771_b) || parentVal == Biome.func_185362_a((Biome)Biomes.field_150575_M)) {
                    chosen = BiomeGroupsModern.OCEANS[this.func_75902_a(BiomeGroupsModern.OCEANS.length)];
                } else {
                    int noise = (this.func_75902_a(100) + (x + areaX + y + areaY) / 10) % 3;
                    switch (noise) {
                        case 0: {
                            chosen = BiomeGroupsModern.HOT[this.func_75902_a(BiomeGroupsModern.HOT.length)];
                            break;
                        }
                        case 1: {
                            chosen = BiomeGroupsModern.TEMPERATE[this.func_75902_a(BiomeGroupsModern.TEMPERATE.length)];
                            break;
                        }
                        default: {
                            chosen = BiomeGroupsModern.COLD[this.func_75902_a(BiomeGroupsModern.COLD.length)];
                        }
                    }
                }
                dest[index] = Biome.func_185362_a((Biome)chosen);
            }
        }
        return dest;
    }
}

