/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.worldgen;

import de.julianweinelt.ubm.worldgen.biome.BiomeGrove;
import de.julianweinelt.ubm.worldgen.biome.BiomeNetherForest;
import de.julianweinelt.ubm.worldgen.biome.BiomeSnowySlopes;
import de.julianweinelt.ubm.worldgen.biome.BiomeWarmOcean;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ModBiomes {
    private static final List<BiomeData> BIOMES = new ArrayList<BiomeData>();
    public static final Biome NETHER_FOREST = ModBiomes.register("nether_forest", new BiomeNetherForest(), BiomeManager.BiomeType.DESERT, 10, false);
    public static final Biome SNOWY_SLOPES = ModBiomes.register("snowy_slopes", new BiomeSnowySlopes(), BiomeManager.BiomeType.COOL, 10, true);
    public static final Biome GROVE = ModBiomes.register("grove", new BiomeGrove(), BiomeManager.BiomeType.COOL, 10, true);
    public static final Biome WARM_OCEAN = ModBiomes.register("warm_ocean", (Biome)new BiomeWarmOcean(), BiomeManager.BiomeType.WARM, 10, true);

    private static Biome register(String name, Biome biome, BiomeManager.BiomeType type, int weight, boolean spawn) {
        BiomeData data = new BiomeData(name, biome, type, weight, spawn);
        BIOMES.add(data);
        return biome;
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        for (BiomeData data : BIOMES) {
            event.getRegistry().register(data.biome.setRegistryName("ubm", data.name));
        }
    }

    public static void init() {
        for (BiomeData data : BIOMES) {
            BiomeManager.addBiome((BiomeManager.BiomeType)data.type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(data.biome, data.weight));
            if (!data.spawn) continue;
            BiomeManager.addSpawnBiome((Biome)data.biome);
        }
    }

    private static class BiomeData {
        final String name;
        final Biome biome;
        final BiomeManager.BiomeType type;
        final int weight;
        final boolean spawn;

        BiomeData(String name, Biome biome, BiomeManager.BiomeType type, int weight, boolean spawn) {
            this.name = name;
            this.biome = biome;
            this.type = type;
            this.weight = weight;
            this.spawn = spawn;
        }
    }
}

