/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.worldgen;

import de.julianweinelt.ubm.worldgen.ModBiomes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class StructureWorldGen
implements IWorldGenerator {
    private List<Biome> getAllBiomes() {
        ArrayList<Biome> list = new ArrayList<Biome>();
        for (Biome b : ForgeRegistries.BIOMES) {
            list.add(b);
        }
        return list;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            this.generateStructure(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateStructure(World world, Random random, int x, int z) {
        if (random.nextInt(1000) == 0) {
            int y = world.func_175645_m(new BlockPos(x, 0, z)).func_177956_o();
            BlockPos pos = new BlockPos(x, y, z);
            this.placePillagerOutpost(world, new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
        }
        if (random.nextInt(100) == 0) {
            BlockPos pos = new BlockPos(x, random.nextInt(40), z);
            this.placeStructure(world, pos, "amethyst_geode", random, this.getAllBiomes());
        }
    }

    private void placeStructure(World world, BlockPos pos, String structureName, Random random, List<Biome> biomes) {
        if (!biomes.contains(world.func_180494_b(pos))) {
            return;
        }
        TemplateManager manager = world.func_72860_G().func_186340_h();
        ResourceLocation location = new ResourceLocation("ubm", structureName);
        Template template = manager.func_186237_a(world.func_73046_m(), location);
        PlacementSettings settings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.values()[random.nextInt(Rotation.values().length)]).func_186222_a(false);
        template.func_186253_b(world, pos, settings);
    }

    private void placePillagerOutpost(World world, BlockPos pos) {
        List<Biome> biomes = Arrays.asList(Biomes.field_76769_d, Biomes.field_76772_c, ModBiomes.SNOWY_SLOPES, Biomes.field_150588_X, Biomes.field_76774_n, Biomes.field_185441_Q, Biomes.field_76768_g);
        Random random = new Random();
        this.placeStructure(world, pos, "outpost/watchtower", random, biomes);
        this.placeAround(world, pos, random, biomes);
        this.placeAround(world, pos, random, biomes);
        this.placeAround(world, pos, random, biomes);
        this.placeAround(world, pos, random, biomes);
    }

    private void placeAround(World world, BlockPos pos, Random random, List<Biome> biomes) {
        int x = pos.func_177958_n() + (random.nextInt(32) - 16);
        int z = pos.func_177952_p() + (random.nextInt(32) - 16);
        int y = world.func_175645_m(new BlockPos(x, 0, z)).func_177956_o();
        String[] features = new String[]{"outpost/feature_tent1", "outpost/feature_tent2", "outpost/feature_cage1", "outpost/feature_cage2"};
        this.placeStructure(world, new BlockPos(x, y, z), features[random.nextInt(3)], random, biomes);
    }
}

