/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.worldgen.structure.village;

import de.julianweinelt.ubm.UBM;
import de.julianweinelt.ubm.worldgen.structure.village.VillageHouseNBT;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class ModCustomVillage {
    private static final Map<String, int[]> houseSizes = new HashMap<String, int[]>();

    public static void preInit() {
        houseSizes.put("house1", new int[]{8, 7, 7});
        houseSizes.put("house2", new int[]{8, 9, 9});
        houseSizes.put("house3", new int[]{7, 8, 10});
    }

    public static void init() {
        String[] houses;
        MapGenStructureIO.func_143031_a(VillageHouseNBT.class, (String)"VillageHouseNBT");
        for (final String house : houses = new String[]{"house1", "house2", "house3"}) {
            VillagerRegistry.instance().registerVillageCreationHandler(new VillagerRegistry.IVillageCreationHandler(){

                public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int i) {
                    return new StructureVillagePieces.PieceWeight(VillageHouseNBT.class, 15, 1);
                }

                public Class<?> getComponentClass() {
                    return VillageHouseNBT.class;
                }

                public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight weight, StructureVillagePieces.Start start, List pieces, Random rand, int x, int y, int z, EnumFacing facing, int type) {
                    int maxX = houseSizes.getOrDefault(house, new int[]{0, 0, 0})[0];
                    int maxY = houseSizes.getOrDefault(house, new int[]{0, 0, 0})[1];
                    int maxZ = houseSizes.getOrDefault(house, new int[]{0, 0, 0})[2];
                    StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)maxX, (int)maxY, (int)maxZ, (EnumFacing)facing);
                    if (box == null) {
                        return null;
                    }
                    UBM.getLogger().info("Placeing village house 1");
                    return new VillageHouseNBT(start, type, rand, box, facing, house);
                }
            });
        }
    }
}

