/*
 * Decompiled with CFR 0.152.
 */
package de.julianweinelt.ubm.worldgen.structure.village;

import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class VillageHouseNBT
extends StructureVillagePieces.Village {
    private String structureName;

    public VillageHouseNBT() {
    }

    public VillageHouseNBT(StructureVillagePieces.Start start, int type, Random rand, StructureBoundingBox box, EnumFacing facing, String structureName) {
        super(start, type);
        this.func_186164_a(facing);
        this.field_74887_e = box;
        this.structureName = structureName;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
        TemplateManager manager = world.func_72860_G().func_186340_h();
        Template template = manager.func_186237_a(world.func_73046_m(), new ResourceLocation("ubm", "village/" + this.structureName));
        if (template == null) {
            return false;
        }
        int groundY = this.getAverageGroundLevel(world, this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.func_78883_b(), this.field_74887_e.func_78880_d());
        int offsetY = groundY - this.field_74887_e.field_78895_b;
        this.field_74887_e.func_78886_a(0, offsetY, 0);
        BlockPos pos = new BlockPos(this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c);
        PlacementSettings settings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186222_a(true);
        template.func_186260_a(world, pos, settings);
        return true;
    }

    private int getAverageGroundLevel(World world, int x, int z, int sizeX, int sizeZ) {
        int total = 0;
        int count = 0;
        for (int dx = 0; dx < sizeX; ++dx) {
            for (int dz = 0; dz < sizeZ; ++dz) {
                BlockPos pos = world.func_175672_r(new BlockPos(x + dx, 0, z + dz));
                total += pos.func_177956_o();
                ++count;
            }
        }
        return count > 0 ? total / count : 64;
    }
}

