/*
 * Decompiled with CFR 0.152.
 */
package expcontainer.block;

import expcontainer.Experience_Container;
import expcontainer.block.entity.ExperienceContainerBlockEntity;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ExperienceContainerBlock
extends class_2237 {
    public static final class_2746 ACTIVE = class_2746.method_11825((String)"active");
    public static class_2753 FACING = class_2741.field_12525;
    final int maxXp = 1628;
    final float factor = 0.9f;

    public ExperienceContainerBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11033));
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 facing = ctx.method_7715().method_10153();
        class_1799 stack = ctx.method_8041();
        class_2487 blockEntityTag = stack.method_7941("BlockEntityTag");
        boolean active = blockEntityTag != null && blockEntityTag.method_10550("StoredXp") > 0;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(active));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ACTIVE});
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ExperienceContainerBlockEntity(pos, state);
    }

    private void dropStoredXp(class_1937 world, class_2338 pos, int amount) {
        if (amount > 0) {
            class_243 center = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            class_1303.method_31493((class_3218)((class_3218)world), (class_243)center, (int)amount);
        }
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 tool) {
        boolean hasSilkTouch;
        super.method_9556(world, player, pos, state, blockEntity, tool);
        boolean bl = hasSilkTouch = class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)tool) > 0;
        if (world.method_8608() || !(blockEntity instanceof ExperienceContainerBlockEntity)) {
            return;
        }
        ExperienceContainerBlockEntity xpBe = (ExperienceContainerBlockEntity)blockEntity;
        int storedXp = xpBe.getStoredXp();
        if (hasSilkTouch) {
            if (storedXp > 0) {
                class_2487 nbt = new class_2487();
                xpBe.method_11007(nbt);
                nbt.method_10551("x");
                nbt.method_10551("y");
                nbt.method_10551("z");
                class_1799 dropStackItem = new class_1799((class_1935)this);
                dropStackItem.method_7959("BlockEntityTag", (class_2520)nbt);
                dropStackItem.method_7948().method_10569("CustomModelData", 1);
                dropStackItem.method_7948().method_10556("Active", true);
                ExperienceContainerBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)dropStackItem);
            } else {
                this.dropStoredXp(world, pos, storedXp);
                class_1799 empty = new class_1799((class_1935)this);
                empty.method_7948().method_10569("CustomModelData", 0);
                ExperienceContainerBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)empty);
            }
            if (xpBe.getStoredXp() < 0) {
                int rewrite = xpBe.getStoredXp();
                xpBe.addXp(rewrite * -1);
                Experience_Container.LOGGER.error("Experience barrel exp is negative, so set barrel exp to 0");
            }
        } else if (storedXp >= 0) {
            this.dropStoredXp(world, pos, storedXp);
            class_1799 Default = new class_1799((class_1935)this);
            ExperienceContainerBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)Default);
        }
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2487 nbt;
        super.method_9567(world, pos, state, placer, itemStack);
        if (world.field_9236) {
            return;
        }
        if (itemStack.method_7985() && (nbt = itemStack.method_7941("BlockEntityTag")) != null && nbt.method_10545("StoredXp")) {
            short storedXp = nbt.method_10568("StoredXp");
            boolean active = storedXp > 0;
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
            class_2586 be = world.method_8321(pos);
            if (be instanceof ExperienceContainerBlockEntity) {
                ExperienceContainerBlockEntity xpBe = (ExperienceContainerBlockEntity)be;
                xpBe.method_11014(nbt);
            }
        }
    }

    public static int getExperienceForLevel(int level) {
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    public static int getLevelFromExperience(int xp) {
        int level = 0;
        while (xp >= ExperienceContainerBlock.getExperienceForLevel(level + 1)) {
            ++level;
        }
        return level;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 be;
        if (!world.field_9236 && (be = world.method_8321(pos)) instanceof ExperienceContainerBlockEntity) {
            ExperienceContainerBlockEntity xpBe = (ExperienceContainerBlockEntity)be;
            int newLevel = ExperienceContainerBlock.getLevelFromExperience(xpBe.getStoredXp());
            int current = xpBe.getStoredXp();
            int spaceLeft = 1628 - current;
            int playerXp = player.field_7495;
            if (spaceLeft < 0) {
                int rewrite = xpBe.getStoredXp();
                xpBe.addXp(rewrite * -1);
                Experience_Container.LOGGER.error("Negative exp in expcontainer?");
            }
            if (spaceLeft == 0) {
                class_5250 part2 = class_2561.method_43469((String)"message.expcontainer.max_level", (Object[])new Object[]{newLevel}).method_27692(class_124.field_1054);
                class_5250 finalMessage = class_2561.method_43469((String)"message.expcontainer.full_barrel", (Object[])new Object[]{part2});
                world.method_8396(null, pos, class_3417.field_14627, class_3419.field_15245, 0.6f, 2.0f);
                player.method_7353((class_2561)finalMessage, true);
                return class_1269.field_5812;
            }
            if (playerXp > 0) {
                if (spaceLeft > 0) {
                    int playerExp = (int)((float)playerXp * 0.9f);
                    int added = Math.min(spaceLeft, playerExp);
                    int toRemove = (int)Math.ceil((float)added / 0.9f);
                    toRemove = Math.min(playerXp, toRemove);
                    int newPlayerXp = playerXp - toRemove;
                    xpBe.addXp(added);
                    player.field_7520 = 0;
                    player.field_7510 = 0.0f;
                    player.field_7495 = 0;
                    player.method_7255(newPlayerXp);
                    boolean active = xpBe.getStoredXp() > 0;
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
                    world.method_8396(null, pos, class_3417.field_14627, class_3419.field_15245, 0.6f, 1.0f);
                    int level = ExperienceContainerBlock.getLevelFromExperience(added);
                    class_5250 ADDED = class_2561.method_43469((String)"message.expcontainer.added", (Object[])new Object[]{added, level}).method_27692(class_124.field_1068);
                    player.method_7353((class_2561)ADDED, true);
                }
            } else {
                world.method_8396(null, pos, class_3417.field_14627, class_3419.field_15245, 0.3f, 0.5f);
                class_5250 STORED = class_2561.method_43469((String)"message.expcontainer.stored", (Object[])new Object[]{xpBe.getStoredXp(), newLevel}).method_27692(class_124.field_1068);
                player.method_7353((class_2561)STORED, true);
            }
        }
        return class_1269.field_5812;
    }

    public static void registerBlock() {
        Experience_Container.LOGGER.info("Registering blocks to give exp");
    }
}

