/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.annotateddi.impl.di;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import dev.the_fireplace.annotateddi.impl.di.ImplementationContainer;
import dev.the_fireplace.annotateddi.impl.di.ImplementationData;
import dev.the_fireplace.annotateddi.impl.di.ImplementationException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;

public final class AnnotatedDIConfigModule
extends AbstractModule {
    private final ImplementationContainer implementationContainer;

    public AnnotatedDIConfigModule(ImplementationContainer implementationContainer) {
        this.implementationContainer = implementationContainer;
    }

    protected void configure() {
        this.bindImplementation();
    }

    private void bindImplementation() {
        for (Map.Entry<Class, List<ImplementationData>> classImplementations : this.implementationContainer.implementations().entrySet()) {
            if (classImplementations.getValue().size() == 1) {
                ImplementationData implementationData = classImplementations.getValue().get(0);
                this.bindImplementationData(implementationData);
                continue;
            }
            for (ImplementationData implementationData : classImplementations.getValue()) {
                this.bindImplementationData(implementationData);
            }
        }
    }

    private void bindImplementationData(ImplementationData implementationData) {
        this.bindImplementationToInterface(implementationData.implementation(), implementationData.interfaces(), implementationData.name(), implementationData.useAllInterfaces());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bindImplementationToInterface(Class implementation, List<Class> injectableInterfaces, String name, boolean useAllInterfaces) {
        boolean hasExplicitBindings;
        boolean bl = hasExplicitBindings = injectableInterfaces.size() != 1 || !injectableInterfaces.get(0).equals(Object.class);
        if (hasExplicitBindings) {
            this.bindToInterfaces(implementation, injectableInterfaces, name);
            return;
        } else {
            Class<?>[] interfaces = implementation.getInterfaces();
            if (interfaces.length == 1) {
                this.bindWithOptionalName(interfaces[0], implementation, name);
                return;
            } else {
                if (interfaces.length <= 1) throw new ImplementationException(String.format("No interfaces found for @Implementation annotated class %s, please set the value(s) to pick the correct one(s).", implementation.getCanonicalName()));
                if (!useAllInterfaces) throw new ImplementationException(String.format("Multiple interfaces found for @Implementation annotated class %s, please set the value(s) to pick the correct one(s).", implementation.getCanonicalName()));
                this.bindToInterfaces(implementation, List.of(interfaces), name);
            }
        }
    }

    private void bindToInterfaces(Class implementation, List<Class> injectableInterfaces, String name) {
        for (Class injectableInterface : injectableInterfaces) {
            this.bindWithOptionalName(injectableInterface, implementation, name);
        }
    }

    private void bindWithOptionalName(Class injectableInterface, Class implementation, String name) {
        if (name.isBlank()) {
            this.bind(injectableInterface).to(implementation);
        } else {
            this.bind(injectableInterface).annotatedWith((Annotation)Names.named((String)name)).to(implementation);
        }
    }
}

