/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.annotateddi.impl.di;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.the_fireplace.annotateddi.impl.AnnotatedDIConstants;
import dev.the_fireplace.annotateddi.impl.di.ImplementationContainer;
import dev.the_fireplace.annotateddi.impl.di.ImplementationData;
import dev.the_fireplace.annotateddi.impl.domain.loader.LoaderHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public final class ImplementationScanner {
    public static final String DI_CONFIG_FILE_NAME = "annotated-di.json";
    private final LoaderHelper loaderHelper;

    @Inject
    public ImplementationScanner(LoaderHelper loaderHelper) {
        this.loaderHelper = loaderHelper;
    }

    public Optional<ImplementationContainer> readImplementationContainerFromPath(Path path) {
        ImplementationContainer implementationContainer = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8));){
            JsonElement jsonElement = JsonParser.parseReader((Reader)br);
            if (jsonElement instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)jsonElement;
                implementationContainer = this.readImplementationContainerJson(jsonObject);
                AnnotatedDIConstants.getLogger().debug("Found valid DI config at {}", (Object)path);
            }
        }
        catch (JsonParseException | IOException | ClassNotFoundException e) {
            AnnotatedDIConstants.getLogger().error("Exception when reading implementation file!", e);
        }
        return Optional.ofNullable(implementationContainer);
    }

    private ImplementationContainer readImplementationContainerJson(JsonObject jsonObject) throws ClassNotFoundException {
        JsonArray modImplementations = jsonObject.getAsJsonArray("implementations");
        HashMap<Class, List<ImplementationData>> implementationDatas = new HashMap<Class, List<ImplementationData>>();
        for (JsonElement element : modImplementations) {
            JsonObject implementationObj = (JsonObject)element;
            if (this.isOnWrongEnvironment(implementationObj) || this.isMissingDependencies(implementationObj)) continue;
            JsonArray interfaceNames = implementationObj.getAsJsonArray("interfaces");
            ArrayList interfaces = new ArrayList();
            for (JsonElement interfaceName : interfaceNames) {
                interfaces.add(this.stringToClass(interfaceName.getAsString()));
            }
            Class implementationClass = this.stringToClass(implementationObj.get("class").getAsString());
            ImplementationData implementationData = new ImplementationData(implementationClass, interfaces, implementationObj.has("namedImplementation") ? implementationObj.get("namedImplementation").getAsString() : "", implementationObj.has("useAllInterfaces") && implementationObj.get("useAllInterfaces").getAsBoolean(), implementationObj.has("environment") ? implementationObj.get("environment").getAsString() : null);
            for (Class clazz : interfaces) {
                implementationDatas.computeIfAbsent(clazz, c -> new ArrayList()).add(implementationData);
            }
        }
        return new ImplementationContainer(jsonObject.get("version").getAsString(), implementationDatas);
    }

    private boolean isOnWrongEnvironment(JsonObject implementationObj) {
        return implementationObj.has("environment") && !this.loaderHelper.isOnEnvironment(implementationObj.get("environment").getAsString());
    }

    private boolean isMissingDependencies(JsonObject implementationObj) {
        if (!implementationObj.has("dependencyModIds")) {
            return false;
        }
        JsonArray dependencyModIds = implementationObj.getAsJsonArray("dependencyModIds");
        if (dependencyModIds.isEmpty()) {
            return false;
        }
        for (JsonElement dependencyModId : dependencyModIds) {
            if (this.loaderHelper.isModLoaded(dependencyModId.getAsString())) continue;
            return true;
        }
        return false;
    }

    private Class stringToClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }
}

