/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.annotateddi.impl.injector;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import dev.the_fireplace.annotateddi.api.Injectors;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.annotateddi.impl.domain.injector.InjectorFactory;
import dev.the_fireplace.annotateddi.impl.domain.loader.InjectorNodeFinder;
import dev.the_fireplace.annotateddi.impl.domain.loader.ModInjectableData;
import java.util.Collection;

@Singleton
@Implementation
public final class InjectorFactoryImpl
implements InjectorFactory {
    private final ModInjectableData modInjectableData;
    private final Injector rootInjector;
    private final InjectorNodeFinder injectorNodeFinder;

    @Inject
    public InjectorFactoryImpl(ModInjectableData modInjectableData, Injector rootInjector, InjectorNodeFinder injectorNodeFinder) {
        this.modInjectableData = modInjectableData;
        this.rootInjector = rootInjector;
        this.injectorNodeFinder = injectorNodeFinder;
    }

    @Override
    public Injector create(Collection<String> node) {
        Injector parentInjector = this.getParentInjector(node);
        Collection<AbstractModule> abstractModules = this.modInjectableData.getModules(node);
        return parentInjector.createChildInjector(abstractModules);
    }

    private Injector getParentInjector(Collection<String> node) {
        Collection<String> parentNode = node;
        while ((parentNode = this.injectorNodeFinder.getParentNode(parentNode.toArray(new String[0])[0])) != null && !this.modInjectableData.isInjectable(parentNode)) {
        }
        if (parentNode == null) {
            return this.rootInjector;
        }
        return Injectors.INSTANCE.getAutoInjector(parentNode.toArray(new String[0])[0]);
    }
}

