/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.annotateddi.impl.io;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipError;

public final class FileSystemUtil {
    private static final Map<String, String> jfsArgsCreate = Collections.singletonMap("create", "true");
    private static final Map<String, String> jfsArgsEmpty = Collections.emptyMap();

    private FileSystemUtil() {
    }

    public static FileSystemDelegate getJarFileSystem(Path path, boolean create) throws IOException {
        return FileSystemUtil.getJarFileSystem(path.toUri(), create);
    }

    public static FileSystemDelegate getJarFileSystem(URI uri, boolean create) throws IOException {
        FileSystem ret;
        URI jarUri;
        try {
            jarUri = new URI("jar:" + uri.getScheme(), uri.getHost(), uri.getPath(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        boolean opened = false;
        try {
            ret = FileSystems.getFileSystem(jarUri);
        }
        catch (FileSystemNotFoundException ignore) {
            try {
                ret = FileSystems.newFileSystem(jarUri, create ? jfsArgsCreate : jfsArgsEmpty);
                opened = true;
            }
            catch (FileSystemAlreadyExistsException ignore2) {
                ret = FileSystems.getFileSystem(jarUri);
            }
            catch (IOException | ZipError e) {
                throw new IOException("Error accessing " + String.valueOf(uri) + ": " + String.valueOf(e), e);
            }
        }
        return new FileSystemDelegate(ret, opened);
    }

    public static class FileSystemDelegate
    implements AutoCloseable {
        private final FileSystem fileSystem;
        private final boolean owner;

        public FileSystemDelegate(FileSystem fileSystem, boolean owner) {
            this.fileSystem = fileSystem;
            this.owner = owner;
        }

        public FileSystem get() {
            return this.fileSystem;
        }

        @Override
        public void close() throws IOException {
            if (this.owner) {
                this.fileSystem.close();
            }
        }
    }
}

