/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.annotateddi.impl.datastructure;

import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LargePowerSet<T>
implements Iterable<Set<T>> {
    private static final Pattern BIT_PATTERN = Pattern.compile("1");
    private final Collection<T> inputEntries;
    private final int minimumSubsetSize;
    private final int maximumSubsetSize;

    public LargePowerSet(Collection<T> inputEntries, int minimumSubsetSize, int maximumSubsetSize) {
        this.inputEntries = inputEntries;
        this.minimumSubsetSize = minimumSubsetSize;
        this.maximumSubsetSize = maximumSubsetSize;
    }

    @Override
    public LargeIterator<T> iterator() {
        return new LargeIterator<T>(this.inputEntries, this.minimumSubsetSize, this.maximumSubsetSize);
    }

    public static class LargeIterator<T>
    implements Iterator<Set<T>> {
        private final List<T> entries;
        private final BigInteger largestCombination;
        private final int minimumSubsetSize;
        private final int maximumSubsetSize;
        private BigInteger currentCombination;
        private Collection<Integer> indicesWithEnabledBit;

        private LargeIterator(Collection<T> inputEntries, int minimumSubsetSize, int maximumSubsetSize) {
            this.entries = ImmutableList.copyOf(inputEntries);
            this.minimumSubsetSize = Math.max(minimumSubsetSize, 0);
            this.maximumSubsetSize = Math.min(maximumSubsetSize, this.entries.size());
            this.currentCombination = BigInteger.ZERO.subtract(BigInteger.ONE);
            this.largestCombination = this.getLargestPossibleCombination(this.entries.size());
        }

        private BigInteger getLargestPossibleCombination(int inputEntryCount) {
            BigInteger largestCombination = BigInteger.valueOf(2L).pow(inputEntryCount).subtract(BigInteger.ONE);
            int rightBitsToZeroOut = largestCombination.bitLength() - Math.min(this.maximumSubsetSize, inputEntryCount);
            largestCombination = largestCombination.shiftRight(rightBitsToZeroOut);
            largestCombination = largestCombination.shiftLeft(rightBitsToZeroOut);
            return largestCombination;
        }

        public boolean shouldBeRebuiltForPerformance(int newInputEntryCount) {
            BigInteger rebuiltIterationCount = this.getLargestPossibleCombination(newInputEntryCount);
            return this.getRemainingIterations().compareTo(rebuiltIterationCount) > 0;
        }

        private BigInteger getRemainingIterations() {
            return this.largestCombination.subtract(this.currentCombination).subtract(BigInteger.ONE);
        }

        @Override
        public boolean hasNext() {
            if (this.currentCombination.equals(BigInteger.valueOf(-1L))) {
                return this.entries.size() >= this.minimumSubsetSize;
            }
            return this.largestCombination.compareTo(this.currentCombination) > 0;
        }

        @Override
        public Set<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.findNextIndices();
            HashSet<T> currentSet = new HashSet<T>();
            for (Integer index : this.indicesWithEnabledBit) {
                currentSet.add(this.entries.get(index));
            }
            return currentSet;
        }

        private void findNextIndices() {
            this.currentCombination = this.currentCombination.add(BigInteger.ONE);
            String combinationBinaryValue = this.currentCombination.toString(2);
            this.indicesWithEnabledBit = BIT_PATTERN.matcher(combinationBinaryValue).results().map(MatchResult::start).collect(Collectors.toSet());
            if (this.indicesWithEnabledBit.size() < this.minimumSubsetSize || this.indicesWithEnabledBit.size() > this.maximumSubsetSize) {
                this.findNextIndices();
            }
        }
    }
}

