/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.annotateddi.impl.injector;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import dev.the_fireplace.annotateddi.impl.AnnotatedDIConstants;
import dev.the_fireplace.annotateddi.impl.di.AnnotatedDIConfigModule;
import dev.the_fireplace.annotateddi.impl.di.ImplementationContainer;
import dev.the_fireplace.annotateddi.impl.di.ImplementationData;
import dev.the_fireplace.annotateddi.impl.io.FileSystemUtil;
import dev.the_fireplace.annotateddi.impl.io.UrlUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipError;
import javax.annotation.Nullable;

public final class AnnotatedDIInjectorLoader {
    private static boolean isDevelopmentEnvironment = false;

    public static Injector loadAnnotatedDIInjector() {
        return Guice.createInjector((Stage)AnnotatedDIInjectorLoader.getStage(), (Module[])new Module[]{new AnnotatedDIConfigModule(new AnnotatedDIInjectorLoader().findImplementation())});
    }

    private static Stage getStage() {
        return isDevelopmentEnvironment ? Stage.DEVELOPMENT : Stage.PRODUCTION;
    }

    public static void setDevelopmentEnvironment(boolean developmentEnvironment) {
        isDevelopmentEnvironment = developmentEnvironment;
    }

    private ImplementationContainer findImplementation() {
        try {
            Enumeration<URL> diConfigFileUrls = this.getClass().getClassLoader().getResources("annotated-di.json");
            Set<Path> validConfigFilePaths = this.getConfigFilePaths(diConfigFileUrls);
            if (validConfigFilePaths.size() != 1) {
                StringBuilder formattedError = new StringBuilder(String.format("Only expected one implementation with Annotated DI's logo, found %s.", validConfigFilePaths.size()));
                for (Path path : validConfigFilePaths) {
                    formattedError.append("\r\n").append(path.toString());
                }
                throw new IllegalStateException(formattedError.toString());
            }
            return this.getImplementationContainerFromConfig((Path)validConfigFilePaths.stream().findAny().get());
        }
        catch (IOException e) {
            AnnotatedDIConstants.getLogger().error("Exception when scanning for implementations!", (Throwable)e);
            throw new IllegalStateException("No internal DI config found!");
        }
    }

    private Set<Path> getConfigFilePaths(Enumeration<URL> mods) {
        HashSet<Path> modsList = new HashSet<Path>();
        while (mods.hasMoreElements()) {
            Path configJsonPath;
            block12: {
                Path normalizedPath;
                URL url;
                try {
                    url = UrlUtil.getSource("annotated-di.json", mods.nextElement());
                }
                catch (Exception e) {
                    AnnotatedDIConstants.getLogger().error("Error getting DI config's source!", (Throwable)e);
                    continue;
                }
                try {
                    normalizedPath = UrlUtil.asPath(url).normalize();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Failed to convert URL " + String.valueOf(url) + "!", e);
                }
                if (Files.isDirectory(normalizedPath, new LinkOption[0])) {
                    configJsonPath = normalizedPath.resolve("annotated-di.json");
                    if (!Files.exists(normalizedPath.resolve("AnnotatedDI.png"), new LinkOption[0])) {
                        continue;
                    }
                } else {
                    try {
                        FileSystemUtil.FileSystemDelegate jarFs = FileSystemUtil.getJarFileSystem(normalizedPath, false);
                        configJsonPath = jarFs.get().getPath("annotated-di.json", new String[0]);
                        if (!Files.exists(jarFs.get().getPath("AnnotatedDI.png", new String[0]), new LinkOption[0])) {
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        AnnotatedDIConstants.getLogger().error("Failed to open JAR at " + String.valueOf(normalizedPath) + "!", (Throwable)e);
                    }
                    catch (ZipError e) {
                        AnnotatedDIConstants.getLogger().error("Jar at " + String.valueOf(normalizedPath) + " is corrupted!", (Throwable)e);
                    }
                    continue;
                }
            }
            modsList.add(configJsonPath);
        }
        return modsList;
    }

    private ImplementationContainer getImplementationContainerFromConfig(Path path) {
        ImplementationContainer implementationContainer = this.readImplementationContainerFromPath(path);
        if (implementationContainer == null) {
            throw new IllegalStateException("Unable to read Annotated DI injection config!");
        }
        return implementationContainer;
    }

    @Nullable
    private ImplementationContainer readImplementationContainerFromPath(Path path) {
        ImplementationContainer implementationContainer = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8));){
            JsonElement jsonElement = JsonParser.parseReader((Reader)br);
            if (jsonElement instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)jsonElement;
                implementationContainer = this.readImplementationContainerJson(jsonObject);
            }
        }
        catch (JsonParseException | IOException | ClassNotFoundException e) {
            AnnotatedDIConstants.getLogger().error("Exception when reading implementation file!", e);
        }
        return implementationContainer;
    }

    private ImplementationContainer readImplementationContainerJson(JsonObject jsonObject) throws ClassNotFoundException {
        JsonArray modImplementations = jsonObject.getAsJsonArray("implementations");
        HashMap<Class, List<ImplementationData>> implementationDatas = new HashMap<Class, List<ImplementationData>>();
        for (JsonElement element : modImplementations) {
            JsonObject implementationObj = (JsonObject)element;
            JsonArray interfaceNames = implementationObj.getAsJsonArray("interfaces");
            ArrayList interfaces = new ArrayList();
            for (JsonElement interfaceName : interfaceNames) {
                interfaces.add(this.stringToClass(interfaceName.getAsString()));
            }
            Class implementationClass = this.stringToClass(implementationObj.get("class").getAsString());
            ImplementationData implementationData = new ImplementationData(implementationClass, interfaces, implementationObj.has("namedImplementation") ? implementationObj.get("namedImplementation").getAsString() : "", implementationObj.has("useAllInterfaces") && implementationObj.get("useAllInterfaces").getAsBoolean(), null);
            for (Class clazz : interfaces) {
                implementationDatas.computeIfAbsent(clazz, c -> new ArrayList()).add(implementationData);
            }
        }
        return new ImplementationContainer(jsonObject.get("version").getAsString(), implementationDatas);
    }

    private Class stringToClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }
}

