/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.annotateddi.impl.injector;

import com.google.inject.Injector;
import dev.the_fireplace.annotateddi.api.Injectors;
import dev.the_fireplace.annotateddi.impl.domain.injector.InjectorFactory;
import dev.the_fireplace.annotateddi.impl.domain.loader.InjectorNodeFinder;
import dev.the_fireplace.annotateddi.impl.injector.AnnotatedDIInjectorLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class InjectorManager
implements Injectors {
    private final Map<String, Injector> injectorCache = new HashMap<String, Injector>();

    @Override
    public synchronized Injector getAutoInjector(String modId) {
        if (this.injectorCache.containsKey(modId)) {
            return this.injectorCache.get(modId);
        }
        if (modId.equals("annotateddi")) {
            this.createRootInjector();
            return this.getRootInjector();
        }
        return this.buildModInjector(modId);
    }

    public Injector buildModInjector(String modId) {
        Collection<String> node = ((InjectorNodeFinder)this.getRootInjector().getInstance(InjectorNodeFinder.class)).getNode(modId);
        Injector injector = ((InjectorFactory)this.getRootInjector().getInstance(InjectorFactory.class)).create(node);
        this.injectorCache.put(modId, injector);
        return injector;
    }

    private void createRootInjector() {
        Injector injector = AnnotatedDIInjectorLoader.loadAnnotatedDIInjector();
        this.injectorCache.put("annotateddi", injector);
    }

    private Injector getRootInjector() {
        return this.getAutoInjector("annotateddi");
    }
}

