/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.annotateddi.impl.loader;

import com.google.common.collect.Sets;
import dev.the_fireplace.annotateddi.impl.datastructure.LargePowerSet;
import dev.the_fireplace.annotateddi.impl.domain.loader.LoaderHelper;
import dev.the_fireplace.annotateddi.impl.loader.InjectorNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class InjectorTreeBuilder {
    private static final String ROOT_MOD_ID = "minecraft";
    private final LoaderHelper loaderHelper;
    private final Set<String> loadedMods;
    private final Map<String, Set<String>> childMods;
    private final Map<String, Set<String>> parentMods;
    private final Set<InjectorNode> loadedNodes;
    private final Map<String, InjectorNode> nodesByModId;
    private final Map<InjectorNode, Set<InjectorNode>> childNodes;
    private final Map<InjectorNode, Set<InjectorNode>> parentNodes;
    private final Map<InjectorNode, Set<InjectorNode>> dependencyTree;
    private final Map<String, InjectorNode> childParentNodes;

    @Inject
    public InjectorTreeBuilder(LoaderHelper loaderHelper) {
        this.loaderHelper = loaderHelper;
        this.loadedMods = loaderHelper.getLoadedMods().stream().filter(modId -> loaderHelper.findDiConfigPath((String)modId).isPresent()).collect(Collectors.toSet());
        this.childMods = new HashMap<String, Set<String>>(5);
        this.parentMods = new HashMap<String, Set<String>>(5);
        this.loadedNodes = new HashSet<InjectorNode>(5);
        this.nodesByModId = new HashMap<String, InjectorNode>(5);
        this.childNodes = new HashMap<InjectorNode, Set<InjectorNode>>(5);
        this.parentNodes = new HashMap<InjectorNode, Set<InjectorNode>>(5);
        this.dependencyTree = new HashMap<InjectorNode, Set<InjectorNode>>(5);
        this.childParentNodes = new HashMap<String, InjectorNode>(5);
        this.buildTree();
    }

    private void buildTree() {
        this.populateAllParentMods();
        this.populateAllChildMods();
        InjectorNode rootNode = new InjectorNode(Set.of(ROOT_MOD_ID));
        if (this.loaderHelper.isModLoaded("java")) {
            rootNode = rootNode.with("java");
            this.nodesByModId.put("java", rootNode);
        }
        this.loadedNodes.add(rootNode);
        this.nodesByModId.put(ROOT_MOD_ID, rootNode);
        this.populateLoadedNodes();
        this.childMods.clear();
        this.populateAllParentNodes();
        this.parentMods.clear();
        this.populateAllChildNodes();
        this.populateDependencyTree(rootNode, new HashSet<InjectorNode>(), this.getAllChildren(rootNode));
        this.parentNodes.clear();
        this.childNodes.clear();
        this.calculateImmediateParents();
        this.dependencyTree.clear();
    }

    private void populateLoadedNodes() {
        for (String modId : this.loadedMods) {
            if (this.nodesByModId.containsKey(modId)) continue;
            Set<String> codependencies = this.getCodependencies(modId, new HashSet<String>());
            InjectorNode node = new InjectorNode(codependencies);
            this.loadedNodes.add(node);
            for (String nodeMod : node.getModIds()) {
                this.nodesByModId.put(nodeMod, node);
            }
        }
    }

    private Set<String> getCodependencies(String modId, Set<String> visitedMods) {
        HashSet<String> codependencies = new HashSet<String>((Collection<String>)Sets.intersection(this.childMods.getOrDefault(modId, Collections.emptySet()), this.parentMods.getOrDefault(modId, Collections.emptySet())));
        codependencies.add(modId);
        visitedMods.add(modId);
        for (String codependency : codependencies) {
            if (visitedMods.contains(codependency)) continue;
            codependencies.addAll(this.getCodependencies(codependency, visitedMods));
        }
        return codependencies;
    }

    private void calculateImmediateParents() {
        for (Map.Entry<InjectorNode, Set<InjectorNode>> entry : this.dependencyTree.entrySet()) {
            InjectorNode parents = entry.getKey();
            Collection children = entry.getValue();
            for (InjectorNode childNode : children) {
                for (String child : childNode.getModIds()) {
                    this.childParentNodes.put(child, parents);
                }
            }
        }
    }

    private void populateDependencyTree(InjectorNode parentNode, Set<InjectorNode> parentDependencies, Collection<InjectorNode> children) {
        parentDependencies = new HashSet<InjectorNode>(parentDependencies);
        parentDependencies.add(parentNode);
        HashSet<InjectorNode> nodes = new HashSet<InjectorNode>();
        HashSet<InjectorNode> remainingChildren = new HashSet<InjectorNode>();
        for (InjectorNode evaluatingChildNode : children) {
            boolean nodeStartsSelfContainedBranch = this.nodeStartsSelfContainedBranch(parentDependencies, evaluatingChildNode);
            if (nodeStartsSelfContainedBranch) {
                nodes.add(evaluatingChildNode);
                continue;
            }
            remainingChildren.add(evaluatingChildNode);
        }
        nodes.addAll(this.getNodesStartingCombinedBranches(parentDependencies, remainingChildren));
        this.dependencyTree.put(parentNode, nodes);
    }

    private Collection<InjectorNode> getNodesStartingCombinedBranches(Set<InjectorNode> parentDependencies, Set<InjectorNode> remainingChildren) {
        HashSet<InjectorNode> nodes = new HashSet<InjectorNode>();
        Set<InjectorNode> candidateCombinedBranchStarts = this.getCandidateCombinedBranchStarts(parentDependencies, remainingChildren);
        for (int groupSize = 2; groupSize <= candidateCombinedBranchStarts.size(); ++groupSize) {
            LargePowerSet<InjectorNode> powerSet = new LargePowerSet<InjectorNode>(candidateCombinedBranchStarts, groupSize, groupSize);
            boolean finishedScan = false;
            do {
                HashSet confirmedCandidates = new HashSet();
                boolean rebuildPowerSet = false;
                Iterator iterator = powerSet.iterator();
                while (((LargePowerSet.LargeIterator)iterator).hasNext()) {
                    boolean startsCombinedBranch;
                    Object candidateGroup = ((LargePowerSet.LargeIterator)iterator).next();
                    if (candidateGroup.stream().anyMatch(confirmedCandidates::contains) || !(startsCombinedBranch = this.nodeStartsCombinedBranch(parentDependencies, (Set<InjectorNode>)candidateGroup))) continue;
                    nodes.add((InjectorNode)candidateGroup.stream().findAny().orElseThrow());
                    candidateCombinedBranchStarts.removeAll((Collection<?>)candidateGroup);
                    confirmedCandidates.addAll(candidateGroup);
                    if (candidateCombinedBranchStarts.size() < groupSize) break;
                    if (!((LargePowerSet.LargeIterator)iterator).shouldBeRebuiltForPerformance(candidateCombinedBranchStarts.size())) continue;
                    rebuildPowerSet = true;
                    break;
                }
                if (rebuildPowerSet) {
                    confirmedCandidates.clear();
                    powerSet = new LargePowerSet<InjectorNode>(candidateCombinedBranchStarts, groupSize, groupSize);
                    continue;
                }
                finishedScan = true;
            } while (!finishedScan);
        }
        return nodes;
    }

    private boolean nodeStartsCombinedBranch(Set<InjectorNode> parentDependencies, Set<InjectorNode> candidateGroup) {
        InjectorNode[] remainingCandidatesInGroup = candidateGroup.toArray(new InjectorNode[0]);
        InjectorNode firstCandidate = remainingCandidatesInGroup[0];
        remainingCandidatesInGroup = Arrays.copyOfRange(remainingCandidatesInGroup, 1, remainingCandidatesInGroup.length);
        HashSet<InjectorNode> evaluatingGroupAllChildren = new HashSet<InjectorNode>(Set.of(remainingCandidatesInGroup));
        for (InjectorNode candidate : candidateGroup) {
            evaluatingGroupAllChildren.addAll(this.getAllChildren(candidate));
        }
        boolean isSelfContainedGrouping = this.isSelfContainedBranch(parentDependencies, firstCandidate, evaluatingGroupAllChildren);
        if (isSelfContainedGrouping) {
            this.populateDependencyTree(firstCandidate, parentDependencies, evaluatingGroupAllChildren);
            return true;
        }
        return false;
    }

    private Set<InjectorNode> getAllChildren(InjectorNode node) {
        return new HashSet<InjectorNode>(this.childNodes.getOrDefault(node, Collections.emptySet()));
    }

    private Set<InjectorNode> getAllDependencies(InjectorNode node) {
        return new HashSet<InjectorNode>(this.parentNodes.getOrDefault(node, Collections.emptySet()));
    }

    private boolean nodeStartsSelfContainedBranch(Set<InjectorNode> parentDependencies, InjectorNode evaluatingNode) {
        Set<InjectorNode> evaluatingModAllChildren = this.getAllChildren(evaluatingNode);
        boolean hasNoChildren = evaluatingModAllChildren.isEmpty();
        Set<InjectorNode> evaluatingModDependencies = this.getAllDependencies(evaluatingNode);
        boolean branchMeetsImmediateDependencies = parentDependencies.containsAll(evaluatingModDependencies);
        if (branchMeetsImmediateDependencies) {
            if (hasNoChildren) {
                this.dependencyTree.put(evaluatingNode, Collections.emptySet());
                return true;
            }
            boolean isSelfContainedBranch = this.isSelfContainedBranch(parentDependencies, evaluatingNode, evaluatingModAllChildren);
            if (isSelfContainedBranch) {
                this.populateDependencyTree(evaluatingNode, parentDependencies, evaluatingModAllChildren);
                return true;
            }
        }
        return false;
    }

    private boolean isSelfContainedBranch(Collection<InjectorNode> parentDependencies, InjectorNode evaluatingNode, Collection<InjectorNode> evaluatingNodeAllChildren) {
        HashSet<InjectorNode> nodeDependencies = new HashSet<InjectorNode>();
        for (InjectorNode nodeChild : evaluatingNodeAllChildren) {
            nodeDependencies.addAll(this.getAllDependencies(nodeChild));
        }
        HashSet<InjectorNode> branchSelfContainedDependencies = new HashSet<InjectorNode>(parentDependencies);
        branchSelfContainedDependencies.addAll(evaluatingNodeAllChildren);
        branchSelfContainedDependencies.add(evaluatingNode);
        return branchSelfContainedDependencies.containsAll(nodeDependencies);
    }

    private Set<InjectorNode> getCandidateCombinedBranchStarts(Set<InjectorNode> parentDependencies, Set<InjectorNode> remainingChildren) {
        HashSet<InjectorNode> candidateLeaves = new HashSet<InjectorNode>();
        for (InjectorNode evaluatingChildNode : remainingChildren) {
            Set<InjectorNode> evaluatingChildDependencies = this.getAllDependencies(evaluatingChildNode);
            boolean branchMeetsImmediateDependencies = parentDependencies.containsAll(evaluatingChildDependencies);
            if (!branchMeetsImmediateDependencies) continue;
            candidateLeaves.add(evaluatingChildNode);
        }
        return candidateLeaves;
    }

    private void populateAllParentMods() {
        for (String modId : this.loadedMods) {
            this.getParents(modId);
        }
    }

    private Collection<String> getParents(String modId) {
        if (this.parentMods.containsKey(modId)) {
            return this.parentMods.get(modId);
        }
        Collection parents = this.parentMods.computeIfAbsent(modId, k -> new HashSet());
        Collection<String> immediateParents = this.loaderHelper.getDependencies(modId);
        for (String parent : immediateParents) {
            if (!this.loadedMods.contains(parent)) continue;
            parents.add(parent);
            parents.addAll(this.getParents(parent));
            parents.remove(modId);
        }
        if (!this.parentMods.get(modId).contains(ROOT_MOD_ID) && !modId.equals(ROOT_MOD_ID)) {
            this.parentMods.get(modId).add(ROOT_MOD_ID);
        }
        return this.parentMods.get(modId);
    }

    private void populateAllParentNodes() {
        for (InjectorNode node : this.loadedNodes) {
            this.getParents(node);
        }
    }

    private Collection<InjectorNode> getParents(InjectorNode node) {
        if (this.parentNodes.containsKey(node)) {
            return this.parentNodes.get(node);
        }
        Collection parents = this.parentNodes.computeIfAbsent(node, k -> new HashSet());
        for (String modId : node.getModIds()) {
            for (String parentModId : this.getParents(modId)) {
                InjectorNode parentNode = this.nodesByModId.get(parentModId);
                if (parentNode.equals(node)) continue;
                parents.add(parentNode);
            }
        }
        return this.parentNodes.get(node);
    }

    private void populateAllChildNodes() {
        for (InjectorNode node : this.loadedNodes) {
            for (InjectorNode parent : this.getParents(node)) {
                this.childNodes.computeIfAbsent(parent, k -> new HashSet()).add(node);
            }
        }
    }

    private void populateAllChildMods() {
        for (String modId : this.loadedMods) {
            for (String parent : this.getParents(modId)) {
                this.childMods.computeIfAbsent(parent, k -> new HashSet()).add(modId);
            }
        }
    }

    public Map<String, InjectorNode> getNodesByModId() {
        return this.nodesByModId;
    }

    public Map<String, InjectorNode> getChildParentNodes() {
        return this.childParentNodes;
    }
}

