/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.annotateddi.impl.loader;

import com.google.inject.AbstractModule;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.annotateddi.impl.di.AnnotatedDIConfigModule;
import dev.the_fireplace.annotateddi.impl.di.ImplementationContainer;
import dev.the_fireplace.annotateddi.impl.di.ImplementationScanner;
import dev.the_fireplace.annotateddi.impl.domain.loader.LoaderHelper;
import dev.the_fireplace.annotateddi.impl.domain.loader.ModInjectableData;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Implementation
public final class ModInjectableDataImpl
implements ModInjectableData {
    private final Map<String, ImplementationContainer> modDefaultImplementationMap = new ConcurrentHashMap<String, ImplementationContainer>();
    private final Map<String, Collection<AbstractModule>> modCustomModules = new ConcurrentHashMap<String, Collection<AbstractModule>>();
    private final Set<String> modsWithoutDefaultImplementations = new ConcurrentSkipListSet<String>();
    private final LoaderHelper loaderHelper;
    private final ImplementationScanner implementationScanner;

    @Inject
    public ModInjectableDataImpl(LoaderHelper loaderHelper, ImplementationScanner implementationScanner) {
        this.loaderHelper = loaderHelper;
        this.implementationScanner = implementationScanner;
    }

    @Override
    public boolean isInjectable(Collection<String> node) {
        for (String modId : node) {
            this.resolveInjectableDataIfNeeded(modId);
            if (!this.modDefaultImplementationMap.containsKey(modId) && !this.modCustomModules.containsKey(modId)) continue;
            return true;
        }
        return false;
    }

    private void resolveInjectableDataIfNeeded(String modId) {
        if (this.isUnresolved(modId)) {
            this.resolveInjectableData(modId);
        }
    }

    private boolean isUnresolved(String modId) {
        return !this.modsWithoutDefaultImplementations.contains(modId) && !this.modDefaultImplementationMap.containsKey(modId);
    }

    private void resolveInjectableData(String modId) {
        Optional<Path> configPath = this.loaderHelper.findDiConfigPath(modId);
        if (configPath.isPresent()) {
            Optional<ImplementationContainer> container = this.implementationScanner.readImplementationContainerFromPath(configPath.get());
            if (container.isPresent()) {
                this.modDefaultImplementationMap.put(modId, container.get());
            } else {
                this.modsWithoutDefaultImplementations.add(modId);
            }
        } else {
            this.modsWithoutDefaultImplementations.add(modId);
        }
    }

    @Override
    public Collection<AbstractModule> getModules(Collection<String> dependencyTreeNode) {
        HashSet<AbstractModule> abstractModules = new HashSet<AbstractModule>();
        if (this.isInjectable(dependencyTreeNode)) {
            for (String modId : dependencyTreeNode) {
                if (this.modDefaultImplementationMap.containsKey(modId)) {
                    abstractModules.add(new AnnotatedDIConfigModule(this.modDefaultImplementationMap.get(modId)));
                }
                if (!this.modCustomModules.containsKey(modId)) continue;
                abstractModules.addAll(this.modCustomModules.get(modId));
            }
        }
        return abstractModules;
    }

    @Override
    public void addModules(String modId, Collection<AbstractModule> modules) {
        this.modCustomModules.computeIfAbsent(modId, m -> new HashSet()).addAll(modules);
    }
}

