/*
 * Decompiled with CFR 0.152.
 */
package _1ms.McOverTor;

import _1ms.McOverTor.manager.SettingsMgr;
import _1ms.McOverTor.manager.TorManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_639;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main
implements ModInitializer {
    public static final Path confPath = FabricLoader.getInstance().getGameDir().resolve("mcovertor");
    public static final boolean isLinux = System.getProperty("os.name").toLowerCase().contains("linux");
    public static final ThreadLocal<class_639> connIP = new ThreadLocal();
    public static final Logger logger = LogManager.getLogger((String)"McOverTor");

    public void onInitialize() {
        if (isLinux) {
            logger.info("Linux detected!");
        } else {
            logger.info("Windows detected!");
        }
        SettingsMgr.initAndCheckConf();
        Path torrc = confPath.resolve("torrc");
        if (!Files.exists(torrc, new LinkOption[0])) {
            Thread.ofVirtual().name("TorConfigWriter").start(() -> Main.createTorConf(torrc));
        }
        logger.info("McOverTor Loaded!");
    }

    static void createTorConf(Path torrc) {
        try {
            String sep = File.separator.replace("\\", "\\\\");
            Files.writeString(torrc, (CharSequence)("GeoIPFile \"mcovertor" + sep + "geoip\"\nGeoIPv6File \"mcovertor" + sep + "geoip6\""), new OpenOption[0]);
        }
        catch (IOException e) {
            logger.warn("Error while writing Tor config file!");
            throw new RuntimeException(e);
        }
    }

    public static void renderWindow(class_332 context, int x, int y, int windowWidth, int windowHeight, String text) {
        int color = -1;
        context.method_25294(x, y, x + windowWidth, y + windowHeight, Integer.MIN_VALUE);
        int bor1 = x + windowWidth / 2 - 65;
        int bor2 = x + windowWidth / 2 + 65;
        context.method_25294(x, y, bor1, y + 1, -1);
        context.method_25294(x + windowWidth, y, bor2, y + 1, -1);
        context.method_25300(class_310.method_1551().field_1772, text, bor1 + (bor2 - bor1) / 2, y - 5, -1);
        context.method_25294(x, y + windowHeight - 1, x + windowWidth, y + windowHeight, -1);
        context.method_25294(x, y, x + 1, y + windowHeight, -1);
        context.method_25294(x + windowWidth - 1, y, x + windowWidth, y + windowHeight, -1);
    }

    public static void AllTorExtract() {
        logger.info("Extracting Tor files...");
        TorManager.extractTor(isLinux ? "/tor/lnx/tor" : "/tor/tor", "tor");
        if (isLinux) {
            TorManager.extractTor("/tor/lnx/libcrypto.so.3", "libcrypto.so.3");
            TorManager.extractTor("/tor/lnx/libevent-2.1.so.7", "libevent-2.1.so.7");
            TorManager.extractTor("/tor/lnx/libssl.so.3", "libssl.so.3");
        }
        TorManager.extractTor("/tor/geoip", "geoip");
        TorManager.extractTor("/tor/geoip6", "geoip6");
    }

    public static void drawBorder(class_332 context, int x, int y, int width, int height, int color) {
        context.method_25294(x, y, x + width, y + 1, color);
        context.method_25294(x, y + height - 1, x + width, y + height, color);
        context.method_25294(x, y + 1, x + 1, y + height - 1, color);
        context.method_25294(x + width - 1, y + 1, x + width, y + height - 1, color);
    }
}

