/*
 * Decompiled with CFR 0.152.
 */
package _1ms.McOverTor.manager;

import _1ms.McOverTor.Main;
import _1ms.McOverTor.manager.SettingsMgr;
import _1ms.McOverTor.manager.TorOption;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocationMgr {
    private static final Path torrc = Main.confPath.resolve("torrc");
    private static final Logger logger = LogManager.getLogger((String)"McOverTor/Regions");

    public static List<TorRegionInfo> getCtr() {
        List<TorRegionInfo> list;
        block8: {
            Stream<String> stream = Files.lines(Main.confPath.resolve("geoip"));
            try {
                list = stream.filter(c -> !c.startsWith("#") && !c.endsWith("?") && !c.isEmpty()).map(l -> l.substring(l.lastIndexOf(",") + 1)).distinct().map(c -> new TorRegionInfo((String)c, new Locale.Builder().setRegion((String)c).build().getDisplayCountry())).filter(c -> c.name.length() > 2).sorted(Comparator.comparing(TorRegionInfo::name)).toList();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Failed to get countries from tor's db.");
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return list;
    }

    public static Set<String> getSelCtr() {
        try {
            String ln = Files.readAllLines(torrc).getLast().substring(10);
            HashSet<String> codes = new HashSet<String>();
            Matcher mtr = Pattern.compile("\\{([A-Z]{2})}").matcher(ln);
            while (mtr.find()) {
                codes.add(mtr.group(1));
            }
            return codes;
        }
        catch (IOException e) {
            logger.error("Failed to get selected countries");
            throw new RuntimeException(e);
        }
    }

    public static void modRegions(Set<String> regs) {
        try {
            List<String> lines = Files.readAllLines(torrc);
            String lastLn = lines.getLast();
            if (regs.isEmpty()) {
                lines.remove(lastLn);
                if (lines.getLast().startsWith("MiddleNodes")) {
                    for (int i = 0; i < 2; ++i) {
                        lines.remove(lines.getLast());
                    }
                }
            } else {
                StringBuilder toSave = new StringBuilder();
                regs.forEach(e -> toSave.append("{").append((String)e).append("},"));
                if (lastLn.startsWith("ExitNodes")) {
                    lines.remove(lastLn);
                    if (lines.getLast().startsWith("MiddleNodes")) {
                        for (int i = 0; i < 2; ++i) {
                            lines.remove(lines.getLast());
                        }
                    }
                }
                if (SettingsMgr.get(TorOption.allNodes)) {
                    lines.add("EntryNodes " + String.valueOf(toSave));
                    lines.add("MiddleNodes " + String.valueOf(toSave));
                }
                lines.add("ExitNodes " + String.valueOf(toSave));
            }
            Files.write(torrc, lines, new OpenOption[0]);
        }
        catch (IOException e2) {
            logger.error("Failed to apply country modifications");
            throw new RuntimeException(e2);
        }
    }

    public static void remOrAdd(boolean add) {
        try {
            List<String> lines = Files.readAllLines(torrc);
            if (!add) {
                for (int i = 0; i < 2; ++i) {
                    lines.remove(lines.size() - 2);
                }
            } else {
                String toAdd = lines.getLast().substring(10);
                lines.add(lines.size() - 1, "EntryNodes " + toAdd);
                lines.add(lines.size() - 1, "MiddleNodes " + toAdd);
            }
            Files.write(torrc, lines, new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error("Failed to change single/multi nodes application.");
            throw new RuntimeException(e);
        }
    }

    public record TorRegionInfo(String code, String name) {
    }
}

