/*
 * Decompiled with CFR 0.152.
 */
package _1ms.McOverTor.manager;

import _1ms.McOverTor.Main;
import _1ms.McOverTor.manager.TorOption;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;

public class SettingsMgr {
    private static final Path settConf = Main.confPath.resolve("config.cfg");
    private static final Gson gson = new Gson();
    private static HashMap<TorOption, Boolean> settings = new HashMap();
    private static final String ver = "CONFIG_VERSION: 1.4";

    static void saveConfig(boolean first) {
        if (first) {
            for (TorOption opt : TorOption.values()) {
                settings.put(opt, false);
            }
        }
        try {
            Files.writeString(settConf, (CharSequence)(ver + System.lineSeparator() + gson.toJson(settings)), new OpenOption[0]);
        }
        catch (IOException e) {
            Main.logger.error("Failed to save config.");
            throw new RuntimeException(e);
        }
    }

    public static void initAndCheckConf() {
        Runtime.getRuntime().addShutdownHook(Thread.ofVirtual().name("TorCfgSave").unstarted(() -> SettingsMgr.saveConfig(false)));
        if (!Files.exists(Main.confPath, new LinkOption[0])) {
            try {
                Files.createDirectory(Main.confPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                Main.logger.error("Failed to initialize the config");
                throw new RuntimeException(e);
            }
            SettingsMgr.reConf();
            return;
        }
        settings = SettingsMgr.loadConfig();
    }

    public static void flip(TorOption val) {
        settings.replace(val, settings.get((Object)val) == false);
    }

    public static void flip(String val) {
        TorOption valE;
        settings.replace(valE, settings.get((Object)(valE = TorOption.valueOf(val.substring(1)))) == false);
    }

    public static boolean get(TorOption val) {
        return settings.get((Object)val);
    }

    public static boolean get(String val) {
        return settings.get((Object)TorOption.valueOf(val.substring(1))) == false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static HashMap<TorOption, Boolean> loadConfig() {
        try (BufferedReader reader = Files.newBufferedReader(settConf);){
            if (!reader.readLine().equals(ver)) {
                FileUtils.deleteDirectory((File)Main.confPath.toFile());
                Files.createDirectory(Main.confPath, new FileAttribute[0]);
                SettingsMgr.reConf();
                HashMap<TorOption, Boolean> hashMap2 = settings;
                return hashMap2;
            }
            Main.logger.info("LOADING {}", (Object)ver);
            HashMap hashMap = (HashMap)gson.fromJson((Reader)reader, new TypeToken<HashMap<TorOption, Boolean>>(){}.getType());
            return hashMap;
        }
        catch (IOException e) {
            Main.logger.error("Failed to load config.");
            throw new RuntimeException(e);
        }
    }

    static void reConf() {
        SettingsMgr.saveConfig(true);
        Main.AllTorExtract();
        Main.logger.info("Updated config.");
    }
}

