/*
 * Decompiled with CFR 0.152.
 */
package _1ms.McOverTor.manager;

import _1ms.McOverTor.Main;
import _1ms.McOverTor.screen.TorConnect;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TorManager {
    private static Socket socket;
    private static PrintWriter out;
    private static BufferedReader in;
    private static Process torP;
    private static Thread torStopThread;
    static final Path tor;
    public static volatile int progress;
    public static volatile String message;
    public static String sPort;
    private static String cPort;
    private static final Logger logger;
    public static TorConnect connScrn;

    public static void startTor() {
        TorConnect scrn = new TorConnect();
        Objects.requireNonNull(class_310.method_1551()).method_1507((class_437)scrn);
        connScrn = scrn;
        TorManager.launchTor();
    }

    public static void extractTor(String input, String output) {
        Thread.ofVirtual().name("TorFileExtract").start(() -> {
            try (BufferedInputStream in = new BufferedInputStream(Objects.requireNonNull(TorManager.class.getResourceAsStream(input)));
                 BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Main.confPath.resolve(output), new OpenOption[0]));){
                in.transferTo(out);
            }
            catch (IOException e) {
                logger.error("Couldn't extract tor");
                throw new RuntimeException(e);
            }
        });
    }

    private static void launchTor() {
        if (Main.isLinux) {
            try {
                Files.setPosixFilePermissions(tor, PosixFilePermissions.fromString("rwxr-xr-x"));
            }
            catch (IOException e) {
                logger.error("Failed to set Tor PosixFilePermissions.");
                throw new RuntimeException(e);
            }
        }
        ProcessBuilder pb = new ProcessBuilder(tor.toAbsolutePath().toString(), "-f", String.valueOf(Main.confPath) + File.separator + "torrc", "--DataDirectory", Main.confPath.toString(), "--SocksPort", sPort, "--ControlPort", cPort, "--HashedControlPassword", "16:5CC34EC2B16C1DA260CE40B1D139DA73AAFAFF5EA46E17D2E20191BA76");
        if (Main.isLinux) {
            pb.environment().put("LD_LIBRARY_PATH", ":" + String.valueOf(tor.getParent()));
        }
        try {
            torP = pb.start();
            Thread.ofVirtual().name("TorOutputReader").start(TorManager::readTorOutput);
            torStopThread = Thread.ofVirtual().name("TorStopper").unstarted(() -> TorManager.exitTor(false));
            Runtime.getRuntime().addShutdownHook(torStopThread);
            logger.info("Tor successfully launched.");
        }
        catch (IOException e) {
            logger.error("Failed to launch Tor!");
            TorConnect.failToStart = true;
            logger.error((Object)e);
        }
    }

    private static void readTorOutput() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(torP.getInputStream()));){
            String line;
            boolean firstVer = true;
            while ((line = reader.readLine()) != null) {
                if (firstVer) {
                    String[] ver = line.split(" ");
                    logger.info("Starting {} {} {}", (Object)ver[4], (Object)ver[5], (Object)ver[6]);
                    firstVer = false;
                    continue;
                }
                if (line.contains("Address already in use")) {
                    TorManager.killTor(true, false);
                } else if (line.contains("Failed")) {
                    message = "\u00a74" + line.substring(29);
                    logger.info("Error: {}", (Object)message);
                } else {
                    if (!line.contains("Bootstrapped")) continue;
                    progress = Integer.parseInt(line.substring(line.indexOf("Bootstrapped") + 12, line.indexOf("%")).trim());
                    message = line.substring(line.indexOf("%") + 1).trim();
                    logger.info("Progress: {}%, Status: {}", (Object)progress, (Object)message);
                    TorConnect.failToConn = false;
                    if (message.contains("(starting)")) {
                        TorManager.authControl();
                        TorManager.timeOutCheck();
                        continue;
                    }
                    if (progress != 100) continue;
                    TorManager.logsAdjust();
                    connScrn.connCallback();
                }
                break;
            }
        }
        catch (IOException e) {
            logger.error("Error while reading Tor output!");
            TorConnect.failToStart = true;
            logger.error((Object)e);
        }
    }

    private static void resetProg() {
        progress = 0;
        message = "(starting): Starting";
    }

    private static void timeOutCheck() {
        Thread.ofVirtual().name("TorTimeoutChecker").start(() -> {
            int counter = 0;
            int prevProg = 0;
            try {
                int currProg;
                while ((currProg = progress) != 0 && currProg != 100) {
                    if (prevProg == currProg) {
                        ++counter;
                    } else {
                        counter = 0;
                        prevProg = currProg;
                    }
                    if (counter == 10) {
                        TorConnect.failToConn = true;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
            }
        });
    }

    public static void killTor(boolean relaunch, boolean linuxKill) {
        try {
            if (torStopThread != null) {
                Runtime.getRuntime().removeShutdownHook(torStopThread);
                torStopThread = null;
            }
            if (Main.isLinux) {
                if (linuxKill) {
                    new ProcessBuilder("killall", "tor").start().waitFor();
                } else {
                    Random rand = new Random();
                    sPort = String.valueOf(rand.nextInt(61001, 65535));
                    while (Objects.equals(cPort = String.valueOf(rand.nextInt(61001, 65535)), sPort)) {
                    }
                    logger.info("Default ports already occupied, switching to Socks: {}, Control: {}", (Object)sPort, (Object)cPort);
                }
            } else {
                new ProcessBuilder("taskkill", "/F", "/IM", "tor").start().waitFor();
            }
            if (relaunch) {
                TorManager.launchTor();
            } else {
                TorManager.resetProg();
            }
            logger.info("Killed already running Tor.");
        }
        catch (IOException | InterruptedException ignored) {
            TorConnect.failToStart = true;
        }
    }

    private static void authControl() {
        try {
            socket = new Socket("127.0.0.1", Integer.parseInt(cPort));
            out = new PrintWriter(socket.getOutputStream(), true);
            out.println("AUTHENTICATE \"TorControlPs01\"");
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            progress = 2;
            message = "(control_auth): Authenticating control port";
            logger.info("Authenticating Tor Control Port..");
            String resp = in.readLine();
            if (resp.contains("250")) {
                logger.info("Tor Control Port Successfully Authenticated.");
                progress = 4;
                return;
            }
        }
        catch (IOException e) {
            logger.error("Tor couldn't be started, control port auth error.");
            TorConnect.failToStart = true;
        }
        torP.destroy();
    }

    public static void exitTor(boolean remHook) {
        try {
            out.println("SIGNAL SHUTDOWN");
            String resp = in.readLine();
            if (resp.contains("250")) {
                TorManager.resetProg();
                socket.close();
                if (remHook) {
                    Runtime.getRuntime().removeShutdownHook(torStopThread);
                    torStopThread = null;
                }
                logger.info("Tor has been closed.");
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.warn("Failed to close Tor.");
        TorManager.killTor(false, true);
    }

    public static int changeCircuits() {
        try {
            out.println("SIGNAL NEWNYM");
            String resp = in.readLine();
            if (resp.contains("250")) {
                logger.info("Circuits changed.");
                return 1;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.warn("Failed to change circuits.");
        return 2;
    }

    private static void logsAdjust() {
        try {
            out.println("SETCONF Log=\"err\"");
            String resp = in.readLine();
            if (resp.contains("250")) {
                logger.info("Adjusted logging levels");
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.warn("Failed to adjust Tor logging levels, potential crash might happen.");
    }

    static {
        tor = Main.confPath.resolve("tor");
        progress = 0;
        message = "(starting): Starting";
        sPort = "9050";
        cPort = "9051";
        logger = LogManager.getLogger((String)"McOverTor/TorControl");
    }
}

