/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.allthesimplechallenges.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class OTPCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"otp").requires(source -> source.hasPermission(0))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> OTPCommand.teleportToPlayer((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> OTPCommand.teleportToPos((CommandContext<CommandSourceStack>)context, BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos"))))).executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"Usage: /otp <player> or /otp <x y z>"));
            return 0;
        }));
    }

    private static int teleportToPlayer(CommandContext<CommandSourceStack> context, ServerPlayer target) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        player.teleportTo(target.serverLevel(), target.getX(), target.getY(), target.getZ(), target.getYRot(), target.getXRot());
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Teleported you to " + target.getDisplayName().getString() + ".")));
        return 1;
    }

    private static int teleportToPos(CommandContext<CommandSourceStack> context, BlockPos pos) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        player.teleportTo(player.serverLevel(), (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, player.getYRot(), player.getXRot());
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("Teleported you to %d, %d, %d.", pos.getX(), pos.getY(), pos.getZ())));
        return 1;
    }
}

