/*
 * Decompiled with CFR 0.152.
 */
package com.fervente.notifications.command;

import com.fervente.notifications.preset.Preset;
import com.fervente.notifications.preset.PresetManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public class AdminNotifyCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder notify = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"notify").requires(src -> src.m_6761_(3))).then(Commands.m_82127_((String)"tell").then(AdminNotifyCommands.notifyTargetsAndMessage(NotifyType.TELL)))).then(Commands.m_82127_((String)"warn").then(AdminNotifyCommands.notifyTargetsAndMessage(NotifyType.WARN)))).then(Commands.m_82127_((String)"preset").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> AdminNotifyCommands.executePreset((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"))))).then(Commands.m_82127_((String)"send").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> AdminNotifyCommands.executePreset((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets")))))));
        LiteralArgumentBuilder pre = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"prenotify").requires(src -> src.m_6761_(3))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"tell").then(AdminNotifyCommands.presetSet(NotifyType.TELL)))).then(Commands.m_82127_((String)"warn").then(AdminNotifyCommands.presetSet(NotifyType.WARN))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            if (PresetManager.removePreset(name)) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Preset '" + name + "' removed")).m_130940_(ChatFormatting.GREEN), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Preset '" + name + "' not found")).m_130940_(ChatFormatting.RED));
            return 0;
        })));
        dispatcher.register(notify);
        dispatcher.register(pre);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> notifyTargetsAndMessage(NotifyType type) {
        return ((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"send").then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> AdminNotifyCommands.executeNotify((CommandContext<CommandSourceStack>)ctx, type, EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), StringArgumentType.getString((CommandContext)ctx, (String)"message")))))).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> AdminNotifyCommands.executeNotify((CommandContext<CommandSourceStack>)ctx, type, EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), StringArgumentType.getString((CommandContext)ctx, (String)"message"))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> presetSet(NotifyType type) {
        return Commands.m_82129_((String)"content", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String content = StringArgumentType.getString((CommandContext)ctx, (String)"content").trim();
            int split = content.lastIndexOf(32);
            if (split <= 0) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Usage: /prenotify set " + AdminNotifyCommands.typeName(type) + " <message> <name>")).m_130940_(ChatFormatting.RED));
                return 0;
            }
            String message = content.substring(0, split).trim();
            String name = content.substring(split + 1).trim();
            if (name.isEmpty() || message.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Message and name must not be empty").m_130940_(ChatFormatting.RED));
                return 0;
            }
            Preset preset = new Preset(name, type, message);
            PresetManager.savePreset(preset);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Preset '" + name + "' saved as " + AdminNotifyCommands.typeName(type))).m_130940_(ChatFormatting.YELLOW), true);
            return 1;
        });
    }

    private static int executeNotify(CommandContext<CommandSourceStack> ctx, NotifyType type, Collection<ServerPlayer> targets, String rawMessage) {
        if (targets == null || targets.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No targets matched").m_130940_(ChatFormatting.RED));
            return 0;
        }
        String msg = rawMessage.trim();
        if (msg.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Message cannot be empty").m_130940_(ChatFormatting.RED));
            return 0;
        }
        ChatFormatting color = type == NotifyType.TELL ? ChatFormatting.YELLOW : ChatFormatting.RED;
        MutableComponent prefix = Component.m_237113_((String)"\u2013 ").m_130944_(new ChatFormatting[]{color, ChatFormatting.BOLD});
        MutableComponent messageText = Component.m_237113_((String)msg).m_130944_(new ChatFormatting[]{color, ChatFormatting.BOLD});
        MutableComponent chat = Component.m_237119_().m_7220_((Component)prefix).m_7220_((Component)messageText);
        MutableComponent actionPrefix = Component.m_237113_((String)"[!] ").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD});
        MutableComponent actionText = Component.m_237113_((String)"Notification received").m_130940_(ChatFormatting.WHITE);
        MutableComponent action = Component.m_237119_().m_7220_((Component)actionPrefix).m_7220_((Component)actionText);
        for (ServerPlayer p : targets) {
            p.m_213846_((Component)chat);
            p.m_5661_((Component)action, true);
            if (type == NotifyType.TELL) {
                p.m_6330_((SoundEvent)SoundEvents.f_12210_.m_203334_(), SoundSource.PLAYERS, 1.0f, 1.0f);
                continue;
            }
            p.m_6330_((SoundEvent)SoundEvents.f_12214_.m_203334_(), SoundSource.PLAYERS, 1.0f, 0.5f);
        }
        String targetInfo = targets.size() == 1 ? Objects.requireNonNull(targets.iterator().next().m_36316_().getName()) : targets.size() + " players";
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Notification sent to " + targetInfo)).m_130940_(ChatFormatting.GREEN), false);
        return targets.size();
    }

    private static int executePreset(CommandContext<CommandSourceStack> ctx, String name, Collection<ServerPlayer> targets) {
        Preset preset = PresetManager.getPreset(name);
        if (preset == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Preset '" + name + "' not found")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        NotifyType type = preset.type();
        return AdminNotifyCommands.executeNotify(ctx, type, targets, preset.message());
    }

    private static String typeName(NotifyType t) {
        return t == NotifyType.TELL ? "tell" : "warn";
    }

    public static enum NotifyType {
        TELL,
        WARN;

    }

    @FunctionalInterface
    private static interface TargetsExecutor {
        public int exec(CommandContext<CommandSourceStack> var1, Collection<ServerPlayer> var2);
    }
}

