/*
 * Decompiled with CFR 0.152.
 */
package com.fervente.notifications.preset;

import com.fervente.notifications.FerventesAdminNotifications;
import com.fervente.notifications.command.AdminNotifyCommands;
import com.fervente.notifications.preset.Preset;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.fml.loading.FMLPaths;

public class PresetManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, Preset> PRESETS = new ConcurrentHashMap<String, Preset>();
    private static boolean initialized = false;

    private static Path filePath() {
        return FMLPaths.CONFIGDIR.get().resolve("ferventes_admin_notifications.json");
    }

    public static synchronized void lazyInit() {
        if (!initialized) {
            PresetManager.load();
            initialized = true;
        }
    }

    public static Preset getPreset(String name) {
        PresetManager.lazyInit();
        if (name == null) {
            return null;
        }
        return PRESETS.get(name.toLowerCase());
    }

    public static Collection<Preset> all() {
        PresetManager.lazyInit();
        return Collections.unmodifiableCollection(PRESETS.values());
    }

    public static synchronized void savePreset(Preset preset) {
        PresetManager.lazyInit();
        PRESETS.put(preset.name().toLowerCase(), preset);
        PresetManager.save();
    }

    public static synchronized boolean removePreset(String name) {
        boolean removed;
        PresetManager.lazyInit();
        if (name == null) {
            return false;
        }
        boolean bl = removed = PRESETS.remove(name.toLowerCase()) != null;
        if (removed) {
            PresetManager.save();
        }
        return removed;
    }

    private static void load() {
        PRESETS.clear();
        Path path = PresetManager.filePath();
        if (!Files.exists(path, new LinkOption[0])) {
            PresetManager.save();
            return;
        }
        try (BufferedReader r = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
            if (root == null) {
                return;
            }
            JsonArray arr = root.has("presets") && root.get("presets").isJsonArray() ? root.getAsJsonArray("presets") : new JsonArray();
            for (JsonElement el : arr) {
                String message;
                if (!el.isJsonObject()) continue;
                JsonObject o = el.getAsJsonObject();
                String name = o.has("name") ? o.get("name").getAsString() : null;
                String typeStr = o.has("type") ? o.get("type").getAsString() : "tell";
                String string = message = o.has("message") ? o.get("message").getAsString() : "";
                if (name == null || message.isEmpty()) continue;
                AdminNotifyCommands.NotifyType type = "warn".equalsIgnoreCase(typeStr) ? AdminNotifyCommands.NotifyType.WARN : AdminNotifyCommands.NotifyType.TELL;
                PRESETS.put(name.toLowerCase(), new Preset(name, type, message));
            }
        }
        catch (IOException e) {
            FerventesAdminNotifications.LOGGER.error("Failed to load presets: {}", (Object)e.toString());
        }
    }

    private static void save() {
        Path path = PresetManager.filePath();
        try {
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            JsonObject root = new JsonObject();
            JsonArray arr = new JsonArray();
            for (Preset p : PRESETS.values()) {
                JsonObject o = new JsonObject();
                o.addProperty("name", p.name());
                o.addProperty("type", p.type() == AdminNotifyCommands.NotifyType.WARN ? "warn" : "tell");
                o.addProperty("message", p.message());
                arr.add((JsonElement)o);
            }
            root.add("presets", (JsonElement)arr);
            try (BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((JsonElement)root, (Appendable)w);
            }
        }
        catch (IOException e) {
            FerventesAdminNotifications.LOGGER.error("Failed to save presets: {}", (Object)e.toString());
        }
    }
}

