/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hoppergadgetry.world.inventory;

import fuzs.hoppergadgetry.init.ModRegistry;
import fuzs.puzzleslib.api.container.v1.ContainerMenuHelper;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GratedHopperMenu
extends AbstractContainerMenu {
    public static final int CONTAINER_SIZE = 5;
    public static final int FILTER_CONTAINER_SIZE = 5;
    private final Container hopper;

    public GratedHopperMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(5), (Container)new SimpleContainer(5));
    }

    public GratedHopperMenu(int containerId, Inventory inventory, Container container, Container filterContainer) {
        super((MenuType)ModRegistry.GRATED_HOPPER_MENU_TYPE.value(), containerId);
        this.hopper = container;
        GratedHopperMenu.checkContainerSize((Container)container, (int)5);
        GratedHopperMenu.checkContainerSize((Container)filterContainer, (int)5);
        container.startOpen((ContainerUser)inventory.player);
        this.addContainerSlots(container, filterContainer);
        ContainerMenuHelper.addInventorySlots((AbstractContainerMenu)this, (Inventory)inventory, (int)82);
    }

    private void addContainerSlots(Container container, Container filterContainer) {
        int i;
        for (i = 0; i < container.getContainerSize(); ++i) {
            this.addSlot(new Slot(container, i, 89 - container.getContainerSize() * 18 / 2 + i * 18, 20));
        }
        for (i = 0; i < filterContainer.getContainerSize(); ++i) {
            this.addSlot(new Slot(this, filterContainer, i, 89 - container.getContainerSize() * 18 / 2 + i * 18, 51){

                public int getMaxStackSize() {
                    return 1;
                }
            });
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index < 5 ? !this.moveItemStackTo(itemStack2, 10, this.slots.size(), true) : (index < 10 ? !this.moveItemStackTo(itemStack2, 10, this.slots.size(), true) : !this.moveItemStackTo(itemStack2, 0, 5, false))) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.hopper.stopOpen((ContainerUser)player);
    }

    public boolean stillValid(Player player) {
        return this.hopper.stillValid(player);
    }
}

