/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hoppergadgetry.world.level.block;

import com.mojang.serialization.MapCodec;
import fuzs.hoppergadgetry.init.ModRegistry;
import fuzs.hoppergadgetry.world.level.block.entity.DuctBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.puzzleslib.api.util.v1.ShapesHelper;
import java.util.Map;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class DuctBlock
extends class_2237
implements TickingEntityBlock<DuctBlockEntity> {
    public static final Map<class_2350, class_2746> PROPERTY_BY_DIRECTION = class_2429.field_11329;
    public static final class_2754<class_2350> FACING = class_2741.field_12525;
    public static final class_2746 ENABLED = class_2741.field_12515;
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    public static final MapCodec<DuctBlock> CODEC = DuctBlock.method_54094(DuctBlock::new);
    private static final class_265 SHAPE = class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final class_265 OUTPUT_SHAPE = class_2248.method_9541((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 INPUT_SHAPE = class_2248.method_9541((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final Map<class_2350, class_265> DIRECTIONAL_OUTPUT_SHAPES = ShapesHelper.rotate((class_265)OUTPUT_SHAPE);
    private static final Map<class_2350, class_265> DIRECTIONAL_INPUT_SHAPES = ShapesHelper.rotate((class_265)INPUT_SHAPE);
    private static final class_265[] SHAPES = DuctBlock.makeVoxelShapes();
    private static final class_2769<?>[] FACING_PROPERTIES = new class_2769[]{class_2741.field_12545, class_2741.field_12525, class_2741.field_12481};

    public DuctBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11033)).method_11657((class_2769)ENABLED, (Comparable)Boolean.TRUE)).method_11657((class_2769)NORTH, (Comparable)Boolean.FALSE)).method_11657((class_2769)EAST, (Comparable)Boolean.FALSE)).method_11657((class_2769)SOUTH, (Comparable)Boolean.FALSE)).method_11657((class_2769)WEST, (Comparable)Boolean.FALSE)).method_11657((class_2769)UP, (Comparable)Boolean.FALSE)).method_11657((class_2769)DOWN, (Comparable)Boolean.FALSE));
    }

    public MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    public class_2591<? extends DuctBlockEntity> getBlockEntityType() {
        return (class_2591)ModRegistry.DUCT_BLOCK_ENTITY_TYPE.comp_349();
    }

    public boolean method_9516(class_2680 blockState, class_10 type) {
        return false;
    }

    protected class_2680 method_9559(class_2680 blockState, class_4538 level, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        blockState = super.method_9559(blockState, level, scheduledTickAccess, blockPos, direction, neighborPos, neighborState, random);
        return (class_2680)blockState.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canConnect(neighborState, direction.method_10153())));
    }

    protected void method_9612(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 neighborBlock, @Nullable class_9904 orientation, boolean movedByPiston) {
        this.checkPoweredState(level, blockPos, blockState);
    }

    public void method_9615(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 oldState, boolean movedByPiston) {
        if (!oldState.method_27852(blockState.method_26204())) {
            this.checkPoweredState(level, blockPos, blockState);
        }
    }

    protected void method_66388(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, boolean movedByPiston) {
        class_1264.method_66221((class_2680)blockState, (class_1937)serverLevel, (class_2338)blockPos);
    }

    protected class_1269 method_55766(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 hitResult) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof class_2614) {
            class_2614 blockEntity = (class_2614)class_25862;
            player.method_17355((class_3908)blockEntity);
        }
        return class_1269.field_21466;
    }

    public boolean method_9498(class_2680 blockState) {
        return true;
    }

    public class_2680 method_9598(class_2680 blockState, class_2470 rotation) {
        return (class_2680)blockState.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)blockState.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 blockState, class_2415 mirror) {
        return blockState.method_26186(mirror.method_10345((class_2350)blockState.method_11654(FACING)));
    }

    public int method_9572(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2350 direction) {
        return class_1703.method_7608((class_2586)level.method_8321(blockPos));
    }

    public class_265 method_9530(class_2680 blockState, class_1922 level, class_2338 blockPos, class_3726 context) {
        class_265 voxelShape = SHAPES[this.getAABBIndex(blockState)];
        return voxelShape != null ? voxelShape : super.method_9530(blockState, level, blockPos, context);
    }

    protected int getAABBIndex(class_2680 blockState) {
        int index = 0;
        for (Map.Entry<class_2350, class_2746> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (!((Boolean)blockState.method_11654((class_2769)entry.getValue())).booleanValue()) continue;
            index |= 1 << entry.getKey().method_10146();
        }
        return index |= 1 << ((class_2350)blockState.method_11654(FACING)).method_10146() + PROPERTY_BY_DIRECTION.size();
    }

    private void checkPoweredState(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        boolean bl;
        boolean bl2 = bl = !level.method_49803(blockPos);
        if (bl != (Boolean)blockState.method_11654((class_2769)ENABLED)) {
            level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(bl)), 2);
        }
    }

    public boolean method_9579(class_2680 blockState) {
        return false;
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 direction = context.method_8038().method_10153();
        class_2680 blockState = (class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)direction)).method_11657((class_2769)ENABLED, (Comparable)Boolean.TRUE);
        for (Map.Entry<class_2350, class_2746> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            class_2680 neighborBlockState = context.method_8045().method_8320(context.method_8037().method_10093(entry.getKey()));
            if (!this.canConnect(neighborBlockState, entry.getKey().method_10153())) continue;
            blockState = (class_2680)blockState.method_11657((class_2769)entry.getValue(), (Comparable)Boolean.TRUE);
        }
        return blockState;
    }

    private boolean canConnect(class_2680 neighborBlockState, class_2350 direction) {
        if (neighborBlockState.method_26164(ModRegistry.DUCT_INPUTS_BLOCK_TAG)) {
            for (class_2769<?> property : FACING_PROPERTIES) {
                if (!neighborBlockState.method_28498(property)) continue;
                return neighborBlockState.method_11654(property) == direction;
            }
            return true;
        }
        return false;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ENABLED, NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    private static class_265[] makeVoxelShapes() {
        class_265[] voxelShapes = new class_265[4096];
        voxelShapes[0] = SHAPE;
        block0: for (int i = 0; i < voxelShapes.length; ++i) {
            int x = i >> PROPERTY_BY_DIRECTION.size();
            if (x == 0 || (x & x - 1) != 0) continue;
            for (class_2350 outputDirection : PROPERTY_BY_DIRECTION.keySet()) {
                if (x != 1 << outputDirection.method_10146()) continue;
                class_265 voxelShape = class_259.method_1084((class_265)SHAPE, (class_265)DIRECTIONAL_OUTPUT_SHAPES.get(outputDirection));
                for (class_2350 inputDirection : PROPERTY_BY_DIRECTION.keySet()) {
                    if (outputDirection == inputDirection || (i & 1 << inputDirection.method_10146()) == 0) continue;
                    voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)DIRECTIONAL_INPUT_SHAPES.get(inputDirection));
                }
                voxelShapes[i] = voxelShape;
                continue block0;
            }
        }
        return voxelShapes;
    }
}

