/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hoppergadgetry.world.level.block;

import fuzs.hoppergadgetry.init.ModRegistry;
import fuzs.hoppergadgetry.world.level.block.entity.DuctBlockEntity;
import fuzs.puzzleslib.api.block.v1.TickingEntityBlock;
import fuzs.puzzleslib.api.shapes.v1.ShapesHelper;
import java.util.Map;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class DuctBlock
extends class_2237
implements TickingEntityBlock {
    public static final Map<class_2350, class_2746> PROPERTY_BY_DIRECTION = class_2429.field_11329;
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2746 ENABLED = class_2741.field_12515;
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    private static final class_265 SHAPE = class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final class_265 OUTPUT_SHAPE = class_2248.method_9541((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 INPUT_SHAPE = class_2248.method_9541((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final Map<class_2350, class_265> DIRECTIONAL_OUTPUT_SHAPES = ShapesHelper.rotate((class_265)OUTPUT_SHAPE);
    private static final Map<class_2350, class_265> DIRECTIONAL_INPUT_SHAPES = ShapesHelper.rotate((class_265)INPUT_SHAPE);
    private static final class_265[] SHAPES = DuctBlock.makeVoxelShapes();
    private static final class_2769<?>[] FACING_PROPERTIES = new class_2769[]{class_2741.field_12545, class_2741.field_12525, class_2741.field_12481};

    public DuctBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11033)).method_11657((class_2769)ENABLED, (Comparable)Boolean.TRUE)).method_11657((class_2769)NORTH, (Comparable)Boolean.FALSE)).method_11657((class_2769)EAST, (Comparable)Boolean.FALSE)).method_11657((class_2769)SOUTH, (Comparable)Boolean.FALSE)).method_11657((class_2769)WEST, (Comparable)Boolean.FALSE)).method_11657((class_2769)UP, (Comparable)Boolean.FALSE)).method_11657((class_2769)DOWN, (Comparable)Boolean.FALSE));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2591<? extends DuctBlockEntity> getBlockEntityType() {
        return (class_2591)ModRegistry.DUCT_BLOCK_ENTITY_TYPE.comp_349();
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return false;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        class_2680 blockState = super.method_9559(state, direction, neighborState, level, pos, neighborPos);
        return (class_2680)blockState.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canConnect(neighborState, direction.method_10153())));
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean movedByPiston) {
        this.checkPoweredState(level, pos, state);
    }

    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean movedByPiston) {
        if (!oldState.method_27852(state.method_26204())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean movedByPiston) {
        DuctBlock.dropContentsOnDestroy(state, newState, level, pos);
        super.method_9536(state, level, pos, newState, movedByPiston);
    }

    @Deprecated
    public static void dropContentsOnDestroy(class_2680 state, class_2680 newState, class_1937 level, class_2338 pos) {
        class_2586 class_25862;
        if (!state.method_27852(newState.method_26204()) && (class_25862 = level.method_8321(pos)) instanceof class_1263) {
            class_1263 container = (class_1263)class_25862;
            class_1264.method_5451((class_1937)level, (class_2338)pos, (class_1263)container);
            level.method_8455(pos, state.method_26204());
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof class_2614) {
            class_2614 blockEntity = (class_2614)class_25862;
            player.method_17355((class_3908)blockEntity);
        }
        return class_1269.field_21466;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return class_1703.method_7608((class_2586)level.method_8321(pos));
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_265 voxelShape = SHAPES[this.getAABBIndex(state)];
        return voxelShape != null ? voxelShape : super.method_9530(state, level, pos, context);
    }

    protected int getAABBIndex(class_2680 blockState) {
        int index = 0;
        for (Map.Entry<class_2350, class_2746> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (!((Boolean)blockState.method_11654((class_2769)entry.getValue())).booleanValue()) continue;
            index |= 1 << entry.getKey().method_10146();
        }
        return index |= 1 << ((class_2350)blockState.method_11654((class_2769)FACING)).method_10146() + PROPERTY_BY_DIRECTION.size();
    }

    private void checkPoweredState(class_1937 level, class_2338 pos, class_2680 state) {
        boolean bl;
        boolean bl2 = bl = !level.method_49803(pos);
        if (bl != (Boolean)state.method_11654((class_2769)ENABLED)) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(bl)), 2);
        }
    }

    public boolean method_9579(class_2680 state, class_1922 level, class_2338 pos) {
        return false;
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 direction = context.method_8038().method_10153();
        class_2680 blockState = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction)).method_11657((class_2769)ENABLED, (Comparable)Boolean.TRUE);
        for (Map.Entry<class_2350, class_2746> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            class_2680 neighborBlockState = context.method_8045().method_8320(context.method_8037().method_10093(entry.getKey()));
            if (!this.canConnect(neighborBlockState, entry.getKey().method_10153())) continue;
            blockState = (class_2680)blockState.method_11657((class_2769)entry.getValue(), (Comparable)Boolean.TRUE);
        }
        return blockState;
    }

    private boolean canConnect(class_2680 neighborBlockState, class_2350 direction) {
        if (neighborBlockState.method_26164(ModRegistry.DUCT_INPUTS_BLOCK_TAG)) {
            for (class_2769<?> property : FACING_PROPERTIES) {
                if (!neighborBlockState.method_28498(property)) continue;
                return neighborBlockState.method_11654(property) == direction;
            }
            return true;
        }
        return false;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        class_2586 class_25862;
        if (stack.method_7938() && (class_25862 = level.method_8321(pos)) instanceof class_2614) {
            class_2614 blockEntity = (class_2614)class_25862;
            blockEntity.method_17488(stack.method_7964());
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ENABLED, NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return this.getBlockEntityType().method_11032(pos, state);
    }

    private static class_265[] makeVoxelShapes() {
        class_265[] voxelShapes = new class_265[4096];
        voxelShapes[0] = SHAPE;
        block0: for (int i = 0; i < voxelShapes.length; ++i) {
            int x = i >> PROPERTY_BY_DIRECTION.size();
            if (x == 0 || (x & x - 1) != 0) continue;
            for (class_2350 outputDirection : PROPERTY_BY_DIRECTION.keySet()) {
                if (x != 1 << outputDirection.method_10146()) continue;
                class_265 voxelShape = class_259.method_1084((class_265)SHAPE, (class_265)DIRECTIONAL_OUTPUT_SHAPES.get(outputDirection));
                for (class_2350 inputDirection : PROPERTY_BY_DIRECTION.keySet()) {
                    if ((i & 1 << inputDirection.method_10146()) == 0) continue;
                    voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)DIRECTIONAL_INPUT_SHAPES.get(inputDirection));
                }
                voxelShapes[i] = voxelShape;
                continue block0;
            }
        }
        return voxelShapes;
    }
}

