/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.sodium.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import team.creative.creativecore.common.util.type.itr.ComputeNextIterator;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.creativecore.common.util.type.list.Tuple;

public class ChunkLayerMapSodium<T>
implements Iterable<T> {
    private static final int LAYERS_COUNT = DefaultTerrainRenderPasses.ALL.length;
    private final T[] content;

    public ChunkLayerMapSodium(ChunkLayerMapSodium<T> map) {
        this.content = Arrays.copyOf(map.content, LAYERS_COUNT);
    }

    public ChunkLayerMapSodium(Function<TerrainRenderPass, T> factory) {
        this.content = new Object[LAYERS_COUNT];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = factory.apply(DefaultTerrainRenderPasses.ALL[i]);
        }
    }

    public ChunkLayerMapSodium() {
        this.content = new Object[LAYERS_COUNT];
    }

    private int index(TerrainRenderPass pass) {
        if (pass == DefaultTerrainRenderPasses.SOLID) {
            return 0;
        }
        if (pass == DefaultTerrainRenderPasses.CUTOUT) {
            return 1;
        }
        if (pass == DefaultTerrainRenderPasses.TRANSLUCENT) {
            return 2;
        }
        throw new IllegalArgumentException(String.valueOf(pass));
    }

    public T get(TerrainRenderPass layer) {
        return this.content[this.index(layer)];
    }

    public T put(TerrainRenderPass layer, T element) {
        int index = this.index(layer);
        T result = this.content[index];
        this.content[index] = element;
        return result;
    }

    public T remove(TerrainRenderPass layer) {
        int index = this.index(layer);
        T result = this.content[index];
        this.content[index] = null;
        return result;
    }

    public void clear() {
        Arrays.fill(this.content, null);
    }

    public Iterable<Tuple<TerrainRenderPass, T>> tuples() {
        return new ComputeNextIterator<Tuple<TerrainRenderPass, T>>(){
            private int index;
            private final Tuple<TerrainRenderPass, T> pair = new Tuple(null, null);

            protected Tuple<TerrainRenderPass, T> computeNext() {
                while (this.index < ChunkLayerMapSodium.this.content.length && ChunkLayerMapSodium.this.content[this.index] == null) {
                    ++this.index;
                }
                if (this.index >= ChunkLayerMapSodium.this.content.length) {
                    return (Tuple)this.end();
                }
                this.pair.key = DefaultTerrainRenderPasses.ALL[this.index];
                this.pair.value = ChunkLayerMapSodium.this.content[this.index];
                ++this.index;
                return this.pair;
            }
        };
    }

    public boolean containsKey(TerrainRenderPass layer) {
        return this.get(layer) != null;
    }

    @Override
    public Iterator<T> iterator() {
        return new ComputeNextIterator<T>(){
            private int index;

            protected T computeNext() {
                while (this.index < ChunkLayerMapSodium.this.content.length && ChunkLayerMapSodium.this.content[this.index] == null) {
                    ++this.index;
                }
                if (this.index >= ChunkLayerMapSodium.this.content.length) {
                    return this.end();
                }
                Object result = ChunkLayerMapSodium.this.content[this.index];
                ++this.index;
                return result;
            }
        };
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "[" + String.join((CharSequence)",", () -> new FunctionIterator((Iterable)this, Object::toString)) + "]";
    }

    public void putEach(T value) {
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = value;
        }
    }
}

