/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.player;

import java.util.function.Consumer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.level.Level;
import team.creative.littletiles.client.level.LevelAwareHandler;
import team.creative.littletiles.client.player.LittleClientPlayerHandler;
import team.creative.littletiles.common.level.little.LittleLevel;

public class LittleClientPlayerConnection
implements LevelAwareHandler {
    private LittleClientPlayerHandler INSTANCE;

    private LittleClientPlayerHandler get() {
        if (this.INSTANCE == null) {
            this.INSTANCE = new LittleClientPlayerHandler();
        }
        return this.INSTANCE;
    }

    public void send(Level level, Packet packet) {
        this.send((LittleLevel)level, packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(LittleLevel level, Packet packet) {
        LittleClientPlayerHandler listener;
        LittleClientPlayerHandler littleClientPlayerHandler = listener = this.get();
        synchronized (littleClientPlayerHandler) {
            Level previous = listener.level;
            listener.level = level.asLevel();
            listener.send(packet);
            listener.level = previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInContext(LittleLevel level, Consumer<LittleClientPlayerHandler> consumer) {
        LittleClientPlayerHandler listener;
        LittleClientPlayerHandler littleClientPlayerHandler = listener = this.get();
        synchronized (littleClientPlayerHandler) {
            Level previous = listener.level;
            listener.level = level.asLevel();
            consumer.accept(listener);
            listener.level = previous;
        }
    }

    @Override
    public void unload() {
        this.INSTANCE = null;
    }
}

