/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.entity;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelDataManager;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.joml.Matrix4f;
import team.creative.littletiles.client.render.entity.LittleEntityRenderer;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.level.little.LittleSubLevel;

@OnlyIn(value=Dist.CLIENT)
public abstract class LittleEntityRenderManager<T extends LittleEntity> {
    public static final Minecraft mc = Minecraft.getInstance();
    public Boolean isInSight;
    public boolean needsFullRenderChunkUpdate = false;
    protected final Set<BlockEntity> globalBlockEntities = Sets.newHashSet();
    private final Int2ObjectMap<BlockDestructionProgress> destroyingBlocks = new Int2ObjectOpenHashMap();
    private final Long2ObjectMap<SortedSet<BlockDestructionProgress>> destructionProgress = new Long2ObjectOpenHashMap();
    private int ticks;
    public final T entity;

    public LittleEntityRenderManager(T entity) {
        this.entity = entity;
    }

    public LittleSubLevel getLevel() {
        return ((LittleEntity)this.entity).getSubLevel();
    }

    public abstract RenderChunkExtender getRenderChunk(long var1);

    public abstract boolean isSmall();

    public void setupRender(Camera camera, @Nullable Frustum frustum, boolean capturedFrustum, boolean spectator) {
        Vec3 cam = camera.getPosition();
        this.isInSight = frustum != null ? Boolean.valueOf(LittleEntityRenderer.isVisible(this.entity, frustum, cam.x, cam.y, cam.z)) : Boolean.valueOf(true);
    }

    public void unload() {
        this.globalBlockEntities.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allChanged() {
        Set<BlockEntity> set = this.globalBlockEntities;
        synchronized (set) {
            this.globalBlockEntities.clear();
        }
    }

    public Iterable<Long2ObjectMap.Entry<SortedSet<BlockDestructionProgress>>> getDestructions() {
        return this.destructionProgress.long2ObjectEntrySet();
    }

    public SortedSet<BlockDestructionProgress> getDestructionProgress(BlockPos pos) {
        return (SortedSet)this.destructionProgress.get(pos.asLong());
    }

    public void clientTick() {
        ++this.ticks;
        if (this.ticks % 20 == 0) {
            ObjectIterator iterator = this.destroyingBlocks.values().iterator();
            while (iterator.hasNext()) {
                BlockDestructionProgress destruction = (BlockDestructionProgress)iterator.next();
                int i = destruction.getUpdatedRenderTick();
                if (this.ticks - i <= 400) continue;
                iterator.remove();
                this.removeProgress(destruction);
            }
        }
    }

    public void destroyBlockProgress(int id, BlockPos pos, int progress) {
        if (progress >= 0 && progress < 10) {
            BlockDestructionProgress destruction = (BlockDestructionProgress)this.destroyingBlocks.get(id);
            if (destruction != null) {
                this.removeProgress(destruction);
            }
            if (destruction == null || !destruction.getPos().equals((Object)pos)) {
                destruction = new BlockDestructionProgress(id, pos);
                this.destroyingBlocks.put(id, (Object)destruction);
            }
            destruction.setProgress(progress);
            destruction.updateTick(this.ticks);
            ((SortedSet)this.destructionProgress.computeIfAbsent(destruction.getPos().asLong(), x -> Sets.newTreeSet())).add(destruction);
        } else {
            BlockDestructionProgress destruction = (BlockDestructionProgress)this.destroyingBlocks.remove(id);
            if (destruction != null) {
                this.removeProgress(destruction);
            }
        }
    }

    private void removeProgress(BlockDestructionProgress destruction) {
        long i = destruction.getPos().asLong();
        Set set = (Set)this.destructionProgress.get(i);
        set.remove(destruction);
        if (set.isEmpty()) {
            this.destructionProgress.remove(i);
        }
    }

    public abstract void compileSections(Camera var1);

    protected MultiBufferSource prepareBlockEntity(PoseStack pose, LittleSubLevel level, BlockPos pos, MultiBufferSource bufferSource) {
        int j1;
        SortedSet<BlockDestructionProgress> sortedset = this.getDestructionProgress(pos);
        MultiBufferSource newSource = bufferSource;
        if (sortedset != null && !sortedset.isEmpty() && (j1 = sortedset.last().getProgress()) >= 0) {
            SheetedDecalTextureGenerator vertexconsumer = new SheetedDecalTextureGenerator(mc.renderBuffers().crumblingBufferSource().getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(j1)), pose.last(), 1.0f);
            newSource = arg_0 -> LittleEntityRenderManager.lambda$prepareBlockEntity$1((VertexConsumer)vertexconsumer, bufferSource, arg_0);
        }
        return newSource;
    }

    protected abstract void renderAllBlockEntities(PoseStack var1, Frustum var2, Vec3 var3, float var4, MultiBufferSource var5);

    protected void renderBlockEntity(BlockEntity blockentity, PoseStack pose, Frustum frustum, Vec3 cam, float frameTime, MultiBufferSource bufferSource) {
        BlockEntityRenderDispatcher dispatcher = mc.getBlockEntityRenderDispatcher();
        BlockEntityRenderer renderer = dispatcher.getRenderer(blockentity);
        if (renderer == null || !frustum.isVisible(((LittleEntity)this.entity).getOrigin().getAABB(renderer.getRenderBoundingBox(blockentity)).toVanilla())) {
            return;
        }
        BlockPos blockpos4 = blockentity.getBlockPos();
        pose.pushPose();
        pose.translate((double)blockpos4.getX() - cam.x, (double)blockpos4.getY() - cam.y, (double)blockpos4.getZ() - cam.z);
        dispatcher.render(blockentity, frameTime, pose, this.prepareBlockEntity(pose, this.getLevel(), blockpos4, bufferSource));
        pose.popPose();
    }

    public void renderBlockEntitiesAndDestruction(PoseStack pose, Frustum frustum, Vec3 cam, float frameTime, MultiBufferSource bufferSource) {
        pose.pushPose();
        ((LittleEntity)this.entity).getOrigin().setupRendering(pose, cam.x, cam.y, cam.z, frameTime);
        this.renderAllBlockEntities(pose, frustum, cam, frameTime, bufferSource);
        LittleSubLevel level = ((LittleEntity)this.entity).getSubLevel();
        for (Long2ObjectMap.Entry<SortedSet<BlockDestructionProgress>> entry : this.getDestructions()) {
            SortedSet sortedset1;
            double d5;
            double d4;
            BlockPos blockpos2 = BlockPos.of((long)entry.getLongKey());
            double d3 = (double)blockpos2.getX() - cam.x;
            if (d3 * d3 + (d4 = (double)blockpos2.getY() - cam.y) * d4 + (d5 = (double)blockpos2.getZ() - cam.z) * d5 > 1024.0 || (sortedset1 = (SortedSet)entry.getValue()) == null || sortedset1.isEmpty()) continue;
            int k1 = ((BlockDestructionProgress)sortedset1.last()).getProgress();
            pose.pushPose();
            pose.translate((double)blockpos2.getX() - cam.x, (double)blockpos2.getY() - cam.y, (double)blockpos2.getZ() - cam.z);
            SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator(mc.renderBuffers().crumblingBufferSource().getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(k1)), pose.last(), 1.0f);
            ModelDataManager manager = ((ILevelExtension)level).getModelDataManager();
            ModelData modelData = null;
            if (manager != null) {
                modelData = manager.getAt(blockpos2);
            }
            mc.getBlockRenderer().renderBreakingTexture(level.getBlockState(blockpos2), blockpos2, (BlockAndTintGetter)level, pose, (VertexConsumer)consumer, modelData == null ? ModelData.EMPTY : modelData);
            pose.popPose();
        }
        pose.popPose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderGlobalEntities(PoseStack pose, Frustum frustum, Vec3 cam, float frameTime, MultiBufferSource bufferSource) {
        Set<BlockEntity> set = this.globalBlockEntities;
        synchronized (set) {
            if (this.globalBlockEntities.isEmpty()) {
                return;
            }
            pose.pushPose();
            ((LittleEntity)this.entity).getOrigin().setupRendering(pose, cam.x, cam.y, cam.z, frameTime);
            for (BlockEntity blockEntity : this.globalBlockEntities) {
                this.renderBlockEntity(blockEntity, pose, frustum, cam, frameTime, bufferSource);
            }
            pose.popPose();
        }
    }

    public abstract void resortTransparency(RenderType var1, double var2, double var4, double var6);

    public abstract void renderChunkLayer(RenderType var1, PoseStack var2, double var3, double var5, double var7, Matrix4f var9, Uniform var10);

    public void blockChanged(BlockGetter level, BlockPos pos, BlockState actualState, BlockState setState, int updateType) {
        this.setBlockDirty(pos, (updateType & 8) != 0);
    }

    protected void setBlockDirty(BlockPos pos, boolean playerChanged) {
        for (int i = pos.getZ() - 1; i <= pos.getZ() + 1; ++i) {
            for (int j = pos.getX() - 1; j <= pos.getX() + 1; ++j) {
                for (int k = pos.getY() - 1; k <= pos.getY() + 1; ++k) {
                    this.setSectionDirty(SectionPos.blockToSectionCoord((int)j), SectionPos.blockToSectionCoord((int)k), SectionPos.blockToSectionCoord((int)i), playerChanged);
                }
            }
        }
    }

    public void setBlocksDirty(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int i = minZ - 1; i <= maxZ + 1; ++i) {
            for (int j = minX - 1; j <= maxX + 1; ++j) {
                for (int k = minY - 1; k <= maxY + 1; ++k) {
                    this.setSectionDirty(SectionPos.blockToSectionCoord((int)j), SectionPos.blockToSectionCoord((int)k), SectionPos.blockToSectionCoord((int)i));
                }
            }
        }
    }

    public void setBlockDirty(BlockPos pos, BlockState actualState, BlockState setState) {
        if (mc.getModelManager().requiresRender(actualState, setState)) {
            this.setBlocksDirty(pos.getX(), pos.getY(), pos.getZ(), pos.getX(), pos.getY(), pos.getZ());
        }
    }

    public void setSectionDirtyWithNeighbors(int x, int y, int z) {
        this.setSectionDirty(x - 1, y - 1, z - 1);
        this.setSectionDirty(x - 1, y, z - 1);
        this.setSectionDirty(x - 1, y + 1, z - 1);
        this.setSectionDirty(x, y - 1, z - 1);
        this.setSectionDirty(x, y, z - 1);
        this.setSectionDirty(x, y + 1, z - 1);
        this.setSectionDirty(x + 1, y - 1, z - 1);
        this.setSectionDirty(x + 1, y, z - 1);
        this.setSectionDirty(x + 1, y + 1, z - 1);
        this.setSectionDirty(x - 1, y - 1, z);
        this.setSectionDirty(x - 1, y, z);
        this.setSectionDirty(x - 1, y + 1, z);
        this.setSectionDirty(x, y - 1, z);
        this.setSectionDirty(x, y, z);
        this.setSectionDirty(x, y + 1, z);
        this.setSectionDirty(x + 1, y - 1, z);
        this.setSectionDirty(x + 1, y, z);
        this.setSectionDirty(x + 1, y + 1, z);
        this.setSectionDirty(x - 1, y - 1, z + 1);
        this.setSectionDirty(x - 1, y, z + 1);
        this.setSectionDirty(x - 1, y + 1, z + 1);
        this.setSectionDirty(x, y - 1, z + -1);
        this.setSectionDirty(x, y, z + 1);
        this.setSectionDirty(x, y + 1, z + 1);
        this.setSectionDirty(x + 1, y - 1, z + 1);
        this.setSectionDirty(x + 1, y, z + 1);
        this.setSectionDirty(x + 1, y + 1, z + 1);
    }

    public void setSectionDirty(int x, int y, int z) {
        this.setSectionDirty(x, y, z, false);
    }

    protected abstract void setSectionDirty(int var1, int var2, int var3, boolean var4);

    private static /* synthetic */ VertexConsumer lambda$prepareBlockEntity$1(VertexConsumer vertexconsumer, MultiBufferSource bufferSource, RenderType type) {
        return type.affectsCrumbling() ? VertexMultiConsumer.create((VertexConsumer)vertexconsumer, (VertexConsumer)bufferSource.getBuffer(type)) : bufferSource.getBuffer(type);
    }
}

