/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.level;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderBlockScreenEffectEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.client.render.cache.build.RenderingThread;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;

public class LittleClientEventHandler {
    private static final ResourceLocation RES_UNDERWATER_OVERLAY = ResourceLocation.withDefaultNamespace((String)"textures/misc/underwater.png");

    @SubscribeEvent
    public synchronized void levelUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            RenderingThread.unload();
        }
    }

    @SubscribeEvent
    public void renderOverlay(RenderBlockScreenEffectEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.WATER) {
            PoseStack pose = new PoseStack();
            Player player = event.getPlayer();
            BlockPos blockpos = BlockPos.containing((Position)player.getEyePosition(TickUtils.getFrameTime((LevelAccessor)player.level())));
            BlockEntity blockEntity = player.level().getBlockEntity(blockpos);
            if (blockEntity instanceof BETiles) {
                BETiles be = (BETiles)blockEntity;
                AABB bb = player.getBoundingBox();
                for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                    LittleTile tile = (LittleTile)pair.value;
                    if (!tile.isFluid((TagKey<Fluid>)FluidTags.WATER) || !tile.intersectsWith(bb, (IParentCollection)pair.key)) continue;
                    RenderSystem.setShader(GameRenderer::getPositionTexShader);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)RES_UNDERWATER_OVERLAY);
                    Tesselator tesselator = Tesselator.getInstance();
                    BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                    float f = LightTexture.getBrightness((DimensionType)player.level().dimensionType(), (int)player.level().getMaxLocalRawBrightness(blockpos));
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.setShaderColor((float)f, (float)f, (float)f, (float)0.1f);
                    Vector3d color = ColorUtils.toVec((int)tile.color);
                    RenderSystem.setShaderColor((float)(f * (float)color.x), (float)(f * (float)color.y), (float)(f * (float)color.z), (float)0.5f);
                    float f7 = -mc.player.getYRot() / 64.0f;
                    float f8 = mc.player.getXRot() / 64.0f;
                    Matrix4f matrix4f = pose.last().pose();
                    bufferbuilder.addVertex(matrix4f, -1.0f, -1.0f, -0.5f).setUv(4.0f + f7, 4.0f + f8);
                    bufferbuilder.addVertex(matrix4f, 1.0f, -1.0f, -0.5f).setUv(0.0f + f7, 4.0f + f8);
                    bufferbuilder.addVertex(matrix4f, 1.0f, 1.0f, -0.5f).setUv(0.0f + f7, 0.0f + f8);
                    bufferbuilder.addVertex(matrix4f, -1.0f, 1.0f, -0.5f).setUv(4.0f + f7, 0.0f + f8);
                    BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.disableBlend();
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }
}

