/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.tile.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;

public class LittleBlockCollection {
    protected HashMap<BlockPos, LittleCollection> content = new HashMap();
    public final BlockPos pos;
    public final LittleGrid grid;

    public LittleBlockCollection(BlockPos pos, LittleGrid grid) {
        this.pos = pos;
        this.grid = grid;
    }

    public void add(LittleGroup group, LittleVec offset) {
        HashMapList map = new HashMapList();
        Iterator<LittleTile> iterator = group.iterator();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            tile.split((HashMapList<BlockPos, LittleBox>)map, this.pos, this.grid, offset, null);
            for (Map.Entry entry : map.entrySet()) {
                LittleCollection collection = this.content.get(entry.getKey());
                if (collection == null) {
                    collection = new LittleCollection();
                    this.content.put((BlockPos)entry.getKey(), collection);
                }
                collection.add(tile.copy((List)entry.getValue()));
            }
            map.clear();
        }
    }

    public Set<Map.Entry<BlockPos, LittleCollection>> entrySet() {
        return this.content.entrySet();
    }
}

