/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.tile.parent;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.level.ILevelProvider;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.attribute.LittleStructureAttribute;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public interface IParentCollection
extends Iterable<LittleTile>,
ILevelProvider {
    public int size();

    public int totalSize();

    public boolean isStructure();

    default public boolean isStructureChildSafe(LittleStructure structure) {
        try {
            return this.isStructureChild(structure);
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            return false;
        }
    }

    public boolean isStructureChild(LittleStructure var1) throws CorruptedConnectionException, NotYetConnectedException;

    public boolean isMain();

    public LittleStructure getStructure() throws CorruptedConnectionException, NotYetConnectedException;

    public int getAttribute();

    public void setAttribute(int var1);

    public boolean isClient();

    public BETiles getBE();

    @Override
    default public Level getLevel() {
        BETiles te = this.getBE();
        if (te.hasLevel()) {
            return te.getLevel();
        }
        throw new IllegalStateException("BlockEntity not loaded yet");
    }

    default public BlockPos getPos() {
        return this.getBE().getBlockPos();
    }

    default public LittleGrid getGrid() {
        return this.getBE().getGrid();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public LittleRenderBox getRenderingBox(LittleTile tile, LittleBox box, RenderType layer) {
        LittleRenderBox renderBox = box.getRenderingBox(this.getGrid(), tile);
        if (renderBox != null && this.isStructure() && LittleStructureAttribute.emissive(this.getAttribute())) {
            renderBox.emissive = true;
        }
        return renderBox;
    }
}

