/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.level.little;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import org.slf4j.Logger;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.mixin.server.level.ChunkSerializerAccessor;
import team.creative.littletiles.server.level.little.LittleServerLevel;

public class LittleChunkSerializer {
    public static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = ChunkSerializerAccessor.getBLOCK_STATE_CODEC();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static LevelChunk read(LittleLevel level, CompoundTag nbt) {
        ChunkPos chunkpos = new ChunkPos(nbt.getInt("xPos"), nbt.getInt("zPos"));
        ListTag listtag = nbt.getList("sections", 10);
        int i = level.getSectionsCount();
        LevelChunkSection[] alevelchunksection = new LevelChunkSection[i];
        boolean chunkSkyLight = level.dimensionType().hasSkyLight();
        ChunkSource chunksource = level.getChunkSource();
        LevelLightEngine levellightengine = chunksource.getLightEngine();
        Registry registry = level.registryAccess().registryOrThrow(Registries.BIOME);
        boolean retained = false;
        for (int j = 0; j < listtag.size(); ++j) {
            boolean hasSkyLight;
            CompoundTag compoundtag = listtag.getCompound(j);
            byte y = compoundtag.getByte("Y");
            int l = level.getSectionIndexFromSectionY(y);
            if (l >= 0 && l < alevelchunksection.length) {
                LevelChunkSection levelchunksection;
                PalettedContainer states = compoundtag.contains("block_states", 10) ? (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundtag.getCompound("block_states")).promotePartial(error -> LittleChunkSerializer.logErrors(chunkpos, y, error)).getOrThrow(ChunkSerializer.ChunkReadException::new) : new PalettedContainer((IdMap)Block.BLOCK_STATE_REGISTRY, (Object)Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
                alevelchunksection[l] = levelchunksection = new LevelChunkSection(states, (PalettedContainerRO)new PalettedContainer(registry.asHolderIdMap(), (Object)registry.getHolderOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES));
            }
            boolean hasBlockLight = compoundtag.contains("BlockLight", 7);
            boolean bl = hasSkyLight = chunkSkyLight && compoundtag.contains("SkyLight", 7);
            if (!hasBlockLight && !hasSkyLight) continue;
            if (!retained) {
                levellightengine.retainData(chunkpos, true);
                retained = true;
            }
            if (hasBlockLight) {
                levellightengine.queueSectionData(LightLayer.BLOCK, SectionPos.of((ChunkPos)chunkpos, (int)y), new DataLayer(compoundtag.getByteArray("BlockLight")));
            }
            if (!hasSkyLight) continue;
            levellightengine.queueSectionData(LightLayer.SKY, SectionPos.of((ChunkPos)chunkpos, (int)y), new DataLayer(compoundtag.getByteArray("SkyLight")));
        }
        LevelChunkTicks blockTicks = LevelChunkTicks.load((ListTag)nbt.getList("block_ticks", 10), x -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse((String)x)), (ChunkPos)chunkpos);
        LevelChunkTicks fluidTicks = LevelChunkTicks.load((ListTag)nbt.getList("fluid_ticks", 10), x -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse((String)x)), (ChunkPos)chunkpos);
        LevelChunk chunk = new LevelChunk(level.asLevel(), chunkpos, UpgradeData.EMPTY, blockTicks, fluidTicks, nbt.getLong("InhabitedTime"), alevelchunksection, LittleChunkSerializer.postLoadChunk(level, nbt), null);
        if (nbt.contains("neoforge:attachments", 10)) {
            chunk.readAttachmentsFromNBT((HolderLookup.Provider)level.registryAccess(), nbt.getCompound("neoforge:attachments"));
        }
        chunk.setLightCorrect(nbt.getBoolean("isLightOn"));
        CompoundTag heightmaps = nbt.getCompound("Heightmaps");
        EnumSet<Heightmap.Types> enumset = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types type : chunk.getPersistedStatus().heightmapsAfter()) {
            String s = type.getSerializationKey();
            if (heightmaps.contains(s, 12)) {
                chunk.setHeightmap(type, heightmaps.getLongArray(s));
                continue;
            }
            enumset.add(type);
        }
        Heightmap.primeHeightmaps((ChunkAccess)chunk, enumset);
        if (nbt.getBoolean("shouldSave")) {
            chunk.setUnsaved(true);
        }
        ListTag blockEntities = nbt.getList("block_entities", 10);
        for (int j = 0; j < blockEntities.size(); ++j) {
            chunk.setBlockEntityNbt(blockEntities.getCompound(j));
        }
        NeoForge.EVENT_BUS.post((Event)new ChunkDataEvent.Load((ChunkAccess)chunk, nbt, ChunkType.LEVELCHUNK));
        return chunk;
    }

    private static void logErrors(ChunkPos pos, int y, String error) {
        LOGGER.error("Recoverable errors when loading section [" + pos.x + ", " + y + ", " + pos.z + "]: " + error);
    }

    public static CompoundTag write(LittleServerLevel level, ChunkAccess chunk) {
        ChunkPos chunkpos = chunk.getPos();
        CompoundTag nbt = NbtUtils.addCurrentDataVersion((CompoundTag)new CompoundTag());
        nbt.putInt("xPos", chunkpos.x);
        nbt.putInt("yPos", chunk.getMinSection());
        nbt.putInt("zPos", chunkpos.z);
        nbt.putLong("LastUpdate", level.getGameTime());
        nbt.putLong("InhabitedTime", chunk.getInhabitedTime());
        LevelChunkSection[] alevelchunksection = chunk.getSections();
        ListTag sections = new ListTag();
        ThreadedLevelLightEngine levellightengine = level.getChunkSource().getLightEngine();
        for (int i = levellightengine.getMinLightSection(); i < levellightengine.getMaxLightSection(); ++i) {
            int j = chunk.getSectionIndexFromSectionY(i);
            boolean flag1 = j >= 0 && j < alevelchunksection.length;
            DataLayer blockLight = levellightengine.getLayerListener(LightLayer.BLOCK).getDataLayerData(SectionPos.of((ChunkPos)chunkpos, (int)i));
            DataLayer skyLight = levellightengine.getLayerListener(LightLayer.SKY).getDataLayerData(SectionPos.of((ChunkPos)chunkpos, (int)i));
            if (!flag1 && blockLight == null && skyLight == null) continue;
            CompoundTag sectionTag = new CompoundTag();
            if (flag1) {
                LevelChunkSection levelchunksection = alevelchunksection[j];
                sectionTag.put("block_states", (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)levelchunksection.getStates()).getOrThrow());
            }
            if (blockLight != null && !blockLight.isEmpty()) {
                sectionTag.putByteArray("BlockLight", blockLight.getData());
            }
            if (skyLight != null && !skyLight.isEmpty()) {
                sectionTag.putByteArray("SkyLight", skyLight.getData());
            }
            if (sectionTag.isEmpty()) continue;
            sectionTag.putByte("Y", (byte)i);
            sections.add((Object)sectionTag);
        }
        nbt.put("sections", (Tag)sections);
        if (chunk.isLightCorrect()) {
            nbt.putBoolean("isLightOn", true);
        }
        ListTag blockEntities = new ListTag();
        for (BlockPos blockpos : chunk.getBlockEntitiesPos()) {
            CompoundTag blockEntityTag = chunk.getBlockEntityNbtForSaving(blockpos, (HolderLookup.Provider)level.registryAccess());
            if (blockEntityTag == null) continue;
            blockEntities.add((Object)blockEntityTag);
        }
        nbt.put("block_entities", (Tag)blockEntities);
        LevelChunk levelChunk = (LevelChunk)chunk;
        try {
            CompoundTag capTag = levelChunk.writeAttachmentsToNBT((HolderLookup.Provider)level.registryAccess());
            if (capTag != null) {
                nbt.put("neoforge:attachments", (Tag)capTag);
            }
        }
        catch (Exception exception) {
            LOGGER.error("A capability provider has thrown an exception trying to write state. It will not persist. Report this to the mod author", (Throwable)exception);
        }
        LittleChunkSerializer.saveTicks((Level)level, nbt, chunk.getTicksForSerialization());
        CompoundTag heightmaps = new CompoundTag();
        for (Map.Entry entry : chunk.getHeightmaps()) {
            if (!chunk.getPersistedStatus().heightmapsAfter().contains(entry.getKey())) continue;
            heightmaps.put(((Heightmap.Types)entry.getKey()).getSerializationKey(), (Tag)new LongArrayTag(((Heightmap)entry.getValue()).getRawData()));
        }
        nbt.put("Heightmaps", (Tag)heightmaps);
        NeoForge.EVENT_BUS.post((Event)new ChunkDataEvent.Save(chunk, (LevelAccessor)level, nbt));
        return nbt;
    }

    private static void saveTicks(Level level, CompoundTag nbt, ChunkAccess.TicksToSave ticks) {
        long i = level.getLevelData().getGameTime();
        nbt.put("block_ticks", ticks.blocks().save(i, x -> BuiltInRegistries.BLOCK.getKey(x).toString()));
        nbt.put("fluid_ticks", ticks.fluids().save(i, x -> BuiltInRegistries.FLUID.getKey(x).toString()));
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(LittleLevel level, CompoundTag nbt) {
        ListTag entities = LittleChunkSerializer.getListOfCompoundsOrNull(nbt, "entities");
        ListTag blockEntities = LittleChunkSerializer.getListOfCompoundsOrNull(nbt, "block_entities");
        return entities == null && blockEntities == null ? null : x -> {
            if (entities != null && level instanceof LittleServerLevel) {
                LittleServerLevel sLevel = (LittleServerLevel)level;
                sLevel.addLegacyChunkEntities(EntityType.loadEntitiesRecursive((List)entities, (Level)level.asLevel()));
            }
            if (blockEntities != null) {
                for (int i = 0; i < blockEntities.size(); ++i) {
                    CompoundTag blockTag = blockEntities.getCompound(i);
                    if (blockTag.getBoolean("keepPacked")) {
                        x.setBlockEntityNbt(blockTag);
                        continue;
                    }
                    BlockPos blockpos = BlockEntity.getPosFromTag((CompoundTag)blockTag);
                    BlockEntity blockentity = BlockEntity.loadStatic((BlockPos)blockpos, (BlockState)x.getBlockState(blockpos), (CompoundTag)blockTag, (HolderLookup.Provider)level.registryAccess());
                    if (blockentity == null) continue;
                    x.setBlockEntity(blockentity);
                }
            }
        };
    }

    @Nullable
    private static ListTag getListOfCompoundsOrNull(CompoundTag nbt, String key) {
        ListTag listtag = nbt.getList(key, 10);
        return listtag.isEmpty() ? null : listtag;
    }
}

