/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.level.tick;

import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.level.Level;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.level.handler.LevelHandler;
import team.creative.littletiles.common.level.tick.LittleTickTicket;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.schedule.ISignalSchedulable;

public class LittleTicker
extends LevelHandler
implements Iterable<LittleTickTicket> {
    private final Object2BooleanMap<LittleStructure> updateStructures = new Object2BooleanLinkedOpenHashMap();
    private final HashSet<LittleStructure> tickingStructures = new HashSet();
    private boolean ticking = false;
    private final List<LittleStructure> queuedTickingStructures = new ArrayList<LittleStructure>();
    private List<ISignalSchedulable> signalChanged = new ArrayList<ISignalSchedulable>();
    private boolean processingChanged = false;
    private List<ISignalSchedulable> signalChangedSchedule = new ArrayList<ISignalSchedulable>();
    private final boolean client;
    public int tick = Integer.MIN_VALUE;
    public int latest = Integer.MIN_VALUE;
    public LittleTickTicket next;
    public LittleTickTicket last;
    public LittleTickTicket unused;

    public LittleTicker(Level level) {
        super(level);
        this.client = level.isClientSide;
    }

    protected LittleTickTicket pollUnused() {
        if (this.unused == null) {
            return new LittleTickTicket();
        }
        LittleTickTicket result = this.unused;
        this.unused = result.next;
        result.next = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUpdate(LittleStructure structure, boolean notifyNeighbours) {
        if (this.client) {
            return;
        }
        Object2BooleanMap<LittleStructure> object2BooleanMap = this.updateStructures;
        synchronized (object2BooleanMap) {
            if (notifyNeighbours) {
                this.updateStructures.put((Object)structure, true);
            } else {
                this.updateStructures.put((Object)structure, this.updateStructures.getBoolean((Object)structure));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueNextTick(LittleStructure structure) {
        HashSet<LittleStructure> hashSet = this.tickingStructures;
        synchronized (hashSet) {
            if (this.ticking) {
                this.queuedTickingStructures.add(structure);
            } else {
                this.tickingStructures.add(structure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markSignalChanged(ISignalSchedulable schedulable) {
        if (this.client) {
            return;
        }
        List<ISignalSchedulable> list = this.signalChanged;
        synchronized (list) {
            if (this.processingChanged) {
                this.signalChangedSchedule.add(schedulable);
            } else {
                this.signalChanged.add(schedulable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(int delay, Runnable run) {
        if (this.client) {
            return;
        }
        LittleTicker littleTicker = this;
        synchronized (littleTicker) {
            if (delay < 0) {
                run.run();
            }
            LittleTickTicket result = this.pollUnused();
            result.setup(delay + this.tick, run);
            if (this.latest < result.tickTime) {
                if (this.last != null) {
                    this.last.next = result;
                }
                this.last = result;
                this.latest = result.tickTime;
                if (this.next == null) {
                    this.next = result;
                }
                return;
            }
            if (this.next == null || this.next.tickTime >= result.tickTime) {
                result.next = this.next;
                this.next = result;
                return;
            }
            LittleTickTicket current = this.next;
            while (current.next != null && current.next.tickTime <= result.tickTime) {
                current = current.next;
            }
            result.next = current.next;
            current.next = result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Object object;
        if (!this.client) {
            object = this;
            synchronized (object) {
                while (this.next != null && this.next.tickTime <= this.tick) {
                    this.next.run();
                    if (this.next == this.last) {
                        this.last = null;
                    }
                    LittleTickTicket temp = this.next;
                    this.next = temp.next;
                    temp.next = this.unused != null ? this.unused : null;
                    this.unused = temp;
                }
                ++this.tick;
            }
        }
        object = this.tickingStructures;
        synchronized (object) {
            if (!this.queuedTickingStructures.isEmpty()) {
                for (LittleStructure structure : this.queuedTickingStructures) {
                    this.tickingStructures.add(structure);
                }
                this.queuedTickingStructures.clear();
            }
            this.ticking = true;
            if (!this.tickingStructures.isEmpty()) {
                Iterator<LittleStructure> iterator = this.tickingStructures.iterator();
                while (iterator.hasNext()) {
                    LittleStructure structure;
                    structure = iterator.next();
                    if (structure.queuedTick()) continue;
                    iterator.remove();
                }
            }
            this.ticking = false;
        }
        if (!this.client) {
            if (!this.updateStructures.isEmpty()) {
                object = this.updateStructures;
                synchronized (object) {
                    for (Object2BooleanMap.Entry entry : this.updateStructures.object2BooleanEntrySet()) {
                        LittleStructure structure = (LittleStructure)entry.getKey();
                        if (structure.mainBlock.isRemoved()) continue;
                        LittleTiles.NETWORK.sendToClient(structure.generateUpdatePacket(entry.getBooleanValue()), structure.getStructureLevel(), structure.getStructurePos());
                    }
                    this.updateStructures.clear();
                }
            }
            if (!this.signalChanged.isEmpty()) {
                object = this.signalChanged;
                synchronized (object) {
                    this.processingChanged = true;
                    for (ISignalSchedulable signal : this.signalChanged) {
                        try {
                            signal.updateSignaling();
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
                    }
                    this.signalChanged.clear();
                    this.processingChanged = false;
                    this.signalChanged.addAll(this.signalChangedSchedule);
                    this.signalChangedSchedule.clear();
                }
            }
        }
    }

    @Override
    public Iterator<LittleTickTicket> iterator() {
        return new Iterator<LittleTickTicket>(){
            public LittleTickTicket next;
            {
                this.next = LittleTicker.this.next;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public LittleTickTicket next() {
                LittleTickTicket ticket = this.next;
                this.next = this.next.next;
                return ticket;
            }
        };
    }
}

