/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.setting;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.config.LittleBuildingConfig;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.packet.action.PlacementPlayerSettingPacket;
import team.creative.littletiles.common.placement.mode.PlacementMode;

public class PlacementPlayerSetting {
    public static final String SETTING_KEY = "littletiles:place";
    protected PlacementMode mode;
    protected LittleGrid grid;
    private int configuredGrid;

    @OnlyIn(value=Dist.CLIENT)
    private static LittleGrid gridClient() {
        return LittleTilesClient.ACTION_HANDLER.setting.grid();
    }

    public static LittleGrid grid(Player player) {
        if (player.level().isClientSide) {
            return PlacementPlayerSetting.gridClient();
        }
        CompoundTag nbt = player.getPersistentData().getCompound("PlayerPersisted").getCompound(SETTING_KEY);
        return ((LittleBuildingConfig)LittleTiles.CONFIG.build.get(player)).getOrDefault(nbt.contains("grid") ? nbt.getInt("grid") : -1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static PlacementMode placementModeClient() {
        return LittleTilesClient.ACTION_HANDLER.setting.placementMode();
    }

    public static PlacementMode placementMode(Player player) {
        if (player.level().isClientSide) {
            return PlacementPlayerSetting.placementModeClient();
        }
        CompoundTag nbt = player.getPersistentData().getCompound("PlayerPersisted").getCompound(SETTING_KEY);
        return PlacementMode.getMode(nbt.getString("mode"));
    }

    public PlacementPlayerSetting() {
        this.mode = PlacementMode.getDefault();
        this.configuredGrid = -1;
    }

    public PlacementPlayerSetting(CompoundTag nbt) {
        this.mode = PlacementMode.getMode(nbt.getString("mode"));
        this.configuredGrid = nbt.contains("grid") ? nbt.getInt("grid") : -1;
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("grid", this.configuredGrid);
        nbt.putString("mode", this.mode.getId());
        return nbt;
    }

    public void receive(Player player, PlacementPlayerSetting settings) {
        this.configuredGrid = settings.configuredGrid;
        this.grid = settings.grid;
        this.mode = settings.mode;
        this.refreshGrid(player);
    }

    public LittleGrid grid() {
        return this.grid;
    }

    public PlacementMode placementMode() {
        return this.mode;
    }

    public void changed() {
        LittleTiles.NETWORK.sendToServer((CreativePacket)new PlacementPlayerSettingPacket(this));
    }

    public void grid(LittleGrid grid) {
        this.grid = grid;
        this.configuredGrid = grid.count;
        this.changed();
    }

    public void placementMode(PlacementMode mode) {
        this.mode = mode;
        this.changed();
    }

    public void set(LittleGrid grid, PlacementMode mode) {
        this.grid = grid;
        this.configuredGrid = grid.count;
        this.mode = mode;
        this.changed();
    }

    public void refreshGrid(Player player) {
        this.grid = ((LittleBuildingConfig)LittleTiles.CONFIG.build.get(player)).getOrDefault(this.configuredGrid);
    }
}

