/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.item.ItemPremadeStructure;

public class StructureIngredient
implements ICustomIngredient {
    public static final MapCodec<StructureIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("structure").forGetter(x -> x.structureType)).apply((Applicative)instance, StructureIngredient::new));
    public final String structureType;

    public StructureIngredient(String structureType) {
        this.structureType = structureType;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack.getItem() instanceof ItemMultiTiles) {
            return ItemMultiTiles.getStructure(stack).equals(this.structureType);
        }
        if (stack.getItem() instanceof ItemPremadeStructure) {
            return ItemPremadeStructure.getPremadeId(stack).equals(this.structureType);
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public Stream<ItemStack> getItems() {
        return Stream.of(ItemPremadeStructure.of(this.structureType));
    }

    public IngredientType<?> getType() {
        return (IngredientType)LittleTilesRegistry.STRUCTURE_INGREDIENT_TYPE.get();
    }
}

