/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.logic;

import java.text.ParseException;
import java.util.ArrayList;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.SignalUtils;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.logic.SignalPatternParser;

public abstract class SignalTarget {
    public final int child;

    public static SignalTarget parseTarget(SignalPatternParser parser, boolean onlyOutputs, boolean insideVariable) throws ParseException {
        char begin = parser.next(true);
        if (begin == 'a' || begin == 'b' || begin == 'i' || begin == 'o') {
            boolean input;
            if (insideVariable) {
                throw parser.exception("Invalid usuage of variables in sub equation, only d<index> are allowed");
            }
            boolean external = begin == 'i' || begin == 'o';
            boolean bl = input = begin == 'a' || begin == 'i';
            if (onlyOutputs && input) {
                throw parser.exception("Input cannot be defined in output condition");
            }
            int child = parser.parseNumber();
            if (parser.hasNext() && parser.lookForNext(false) == '[') {
                parser.next(false);
                if (parser.lookForNext(true) == ']') {
                    return new SignalTargetChild(input, child, external);
                }
                SignalCustomIndex first = SignalTarget.parseIndex(parser);
                char next = parser.lookForNext(true);
                if (next == ']') {
                    parser.next(true);
                    if (first instanceof SignalCustomIndexSingle) {
                        return new SignalTargetChildIndex(input, child, external, ((SignalCustomIndexSingle)first).index);
                    }
                    return new SignalTargetChildIndexRange(input, child, external, ((SignalCustomIndexRange)first).index, ((SignalCustomIndexRange)first).length);
                }
                if (next == ',') {
                    ArrayList<SignalCustomIndex> indexes = new ArrayList<SignalCustomIndex>();
                    indexes.add(first);
                    while ((next = parser.next(true)) == ',') {
                        indexes.add(SignalTarget.parseIndex(parser));
                    }
                    if (next == ']') {
                        return new SignalTargetChildCustomIndex(input, child, external, indexes.toArray(new SignalCustomIndex[indexes.size()]));
                    }
                    throw parser.invalidChar(next);
                }
                throw parser.invalidChar(next);
            }
            return new SignalTargetChild(input, child, external);
        }
        if (begin == 'c') {
            int child = parser.parseNumber();
            if (parser.next(false) == '.') {
                return new SignalTargetNested(child, SignalTarget.parseTarget(parser, onlyOutputs, insideVariable));
            }
            throw parser.exception("Missing dot after child input");
        }
        if (begin == 'p') {
            if (parser.next(false) == '.') {
                return new SignalTargetParent(SignalTarget.parseTarget(parser, onlyOutputs, insideVariable));
            }
            throw parser.exception("Missing dot after child input");
        }
        if (begin == 'd') {
            if (!insideVariable) {
                throw parser.exception("Invalid usage of index variable");
            }
            return new SignalTargetIndex(parser.parseNumber());
        }
        throw parser.invalidChar(begin);
    }

    public static SignalCustomIndex parseIndex(SignalPatternParser parser) throws ParseException {
        int start = parser.parseNumber();
        if (parser.lookForNext(true) != '-') {
            return new SignalCustomIndexSingle(start);
        }
        parser.next(true);
        int end = parser.parseNumber();
        if (end <= start) {
            throw parser.exception("Invalid second index " + start + " < " + end);
        }
        return new SignalCustomIndexRange(start, end);
    }

    public static String name(boolean external, boolean input, int index) {
        if (external) {
            return (input ? "i" : "o") + index;
        }
        return (input ? "a" : "b") + index;
    }

    public SignalTarget(int child) {
        this.child = child;
    }

    public final SignalState getState(LittleStructure structure) {
        try {
            return this.getState(this.getTarget(structure));
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            return SignalState.FALSE;
        }
    }

    public final int bandwidth(LittleStructure structure) {
        try {
            return this.getTarget(structure).getBandwidth();
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            return 1;
        }
    }

    protected SignalState getState(ISignalComponent component) throws CorruptedConnectionException, NotYetConnectedException {
        if (component == null) {
            throw new NotYetConnectedException();
        }
        return component.getState();
    }

    public abstract ISignalComponent getTarget(LittleStructure var1);

    public abstract String writeBase();

    public abstract String write();

    public abstract boolean isIndexVariable();

    public int getBandwidth(LittleStructure structure) throws CorruptedConnectionException, NotYetConnectedException {
        ISignalComponent component = this.getTarget(structure);
        if (component != null) {
            return component.getBandwidth();
        }
        return 1;
    }

    public SignalTarget getNestedTarget() {
        return this;
    }

    public static class SignalTargetChild
    extends SignalTarget {
        public final boolean input;
        public final boolean external;

        public SignalTargetChild(boolean input, int child, boolean external) {
            super(child);
            this.input = input;
            this.external = external;
        }

        @Override
        public ISignalComponent getTarget(LittleStructure structure) {
            return this.input ? SignalUtils.getInput(structure, this.child, this.external) : SignalUtils.getOutput(structure, this.child, this.external);
        }

        @Override
        public String writeBase() {
            if (this.external) {
                return (this.input ? "i" : "o") + this.child;
            }
            return (this.input ? "a" : "b") + this.child;
        }

        @Override
        public String write() {
            if (this.external) {
                return (this.input ? "i" : "o") + this.child;
            }
            return (this.input ? "a" : "b") + this.child;
        }

        @Override
        public boolean isIndexVariable() {
            return false;
        }
    }

    public static abstract class SignalCustomIndex {
        public abstract String write();

        public abstract int length();

        public abstract boolean is(SignalState var1);

        public abstract int set(SignalState var1, int var2, SignalState var3);
    }

    public static class SignalCustomIndexSingle
    extends SignalCustomIndex {
        public final int index;

        public SignalCustomIndexSingle(int index) {
            this.index = index;
        }

        @Override
        public boolean is(SignalState state) {
            return state.is(this.index);
        }

        @Override
        public int set(SignalState toModify, int index, SignalState value) {
            toModify.set(index, value.is(index));
            return 1;
        }

        @Override
        public String write() {
            return "" + this.index;
        }

        @Override
        public int length() {
            return 1;
        }
    }

    public static class SignalTargetChildIndex
    extends SignalTargetChild {
        public final int index;

        public SignalTargetChildIndex(boolean input, int child, boolean external, int index) {
            super(input, child, external);
            this.index = index;
        }

        @Override
        protected SignalState getState(ISignalComponent component) throws CorruptedConnectionException, NotYetConnectedException {
            SignalState state = component.getState();
            if (component.getBandwidth() > this.index) {
                return SignalState.of(state.is(this.index));
            }
            return SignalState.FALSE;
        }

        @Override
        public String write() {
            return super.write() + "[" + this.index + "]";
        }

        @Override
        public int getBandwidth(LittleStructure structure) {
            return 1;
        }
    }

    public static class SignalTargetChildIndexRange
    extends SignalTargetChild {
        public final int index;
        public final int length;

        public SignalTargetChildIndexRange(boolean input, int output, boolean external, int index, int length) {
            super(input, output, external);
            this.index = index;
            this.length = length;
        }

        @Override
        protected SignalState getState(ISignalComponent component) throws CorruptedConnectionException, NotYetConnectedException {
            SignalState state = component.getState();
            SignalState newState = SignalState.create(this.length);
            for (int i = 0; i < this.length; ++i) {
                if (component.getBandwidth() <= i + this.index) continue;
                newState = newState.set(i, state.is(this.index + 1));
            }
            return newState;
        }

        @Override
        public String write() {
            return super.write() + "[" + this.index + "-" + this.index + this.length + "]";
        }

        @Override
        public int getBandwidth(LittleStructure structure) {
            return this.length;
        }
    }

    public static class SignalCustomIndexRange
    extends SignalCustomIndex {
        public final int index;
        public final int length;

        public SignalCustomIndexRange(int start, int end) {
            this.index = start;
            this.length = end - this.index + 1;
        }

        @Override
        public boolean is(SignalState state) {
            return state.is(this.index);
        }

        @Override
        public int set(SignalState toModify, int index, SignalState value) {
            for (int i = 0; i < this.length; ++i) {
                toModify.set(index + i, value.is(index + i));
            }
            return this.length;
        }

        @Override
        public String write() {
            return this.index + "-" + (this.index + this.length - 1);
        }

        @Override
        public int length() {
            return this.length;
        }
    }

    public static class SignalTargetChildCustomIndex
    extends SignalTargetChild {
        public final SignalCustomIndex[] indexes;

        public SignalTargetChildCustomIndex(boolean input, int child, boolean external, SignalCustomIndex[] indexes) {
            super(input, child, external);
            this.indexes = indexes;
        }

        @Override
        protected SignalState getState(ISignalComponent component) throws CorruptedConnectionException, NotYetConnectedException {
            SignalState state = component.getState();
            int bandwidth = this.getBandwidth(component.getStructure());
            if (bandwidth == 1) {
                return SignalState.of(this.indexes[0].is(state));
            }
            SignalState newState = SignalState.create(bandwidth);
            int index = 0;
            for (int i = 0; i < this.indexes.length; ++i) {
                index += this.indexes[i].set(newState, index, state);
            }
            return newState;
        }

        @Override
        public String write() {
            String result = super.write() + "[";
            for (int i = 0; i < this.indexes.length; ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = result + this.indexes[i].write();
            }
            return result + "]";
        }

        @Override
        public int getBandwidth(LittleStructure structure) {
            int length = 0;
            for (int i = 0; i < this.indexes.length; ++i) {
                length += this.indexes[i].length();
            }
            return length;
        }
    }

    public static class SignalTargetNested
    extends SignalTarget {
        public final SignalTarget subTarget;

        public SignalTargetNested(int child, SignalTarget subTarget) {
            super(child);
            this.subTarget = subTarget;
        }

        @Override
        protected SignalState getState(ISignalComponent component) throws CorruptedConnectionException, NotYetConnectedException {
            return this.subTarget.getState(component);
        }

        @Override
        public ISignalComponent getTarget(LittleStructure structure) {
            try {
                return this.subTarget.getTarget(structure.children.getChild(this.child).getStructure());
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                return null;
            }
        }

        @Override
        public String writeBase() {
            return "c" + this.child + "." + this.subTarget.writeBase();
        }

        @Override
        public String write() {
            return "c" + this.child + "." + this.subTarget.write();
        }

        @Override
        public boolean isIndexVariable() {
            return this.subTarget.isIndexVariable();
        }

        @Override
        public SignalTarget getNestedTarget() {
            return this.subTarget;
        }
    }

    public static class SignalTargetParent
    extends SignalTarget {
        public final SignalTarget subTarget;

        public SignalTargetParent(SignalTarget subTarget) {
            super(-1);
            this.subTarget = subTarget;
        }

        @Override
        public ISignalComponent getTarget(LittleStructure structure) {
            if (structure.getParent() != null) {
                try {
                    return this.subTarget.getTarget(structure.getParent().getStructure());
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        protected SignalState getState(ISignalComponent component) throws CorruptedConnectionException, NotYetConnectedException {
            return this.subTarget.getState(component);
        }

        @Override
        public String writeBase() {
            return "p." + this.subTarget.writeBase();
        }

        @Override
        public String write() {
            return "p." + this.subTarget.write();
        }

        @Override
        public boolean isIndexVariable() {
            return this.subTarget.isIndexVariable();
        }

        @Override
        public SignalTarget getNestedTarget() {
            return this.subTarget;
        }
    }

    public static class SignalTargetIndex
    extends SignalTarget {
        public SignalTargetIndex(int index) {
            super(index);
        }

        @Override
        public ISignalComponent getTarget(LittleStructure structure) {
            return null;
        }

        @Override
        public String writeBase() {
            return "d" + this.child;
        }

        @Override
        public String write() {
            return "d" + this.child;
        }

        @Override
        public boolean isIndexVariable() {
            return true;
        }
    }
}

