/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.little;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.common.level.little.LevelBlockChangeListener;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.mixin.server.level.MinecraftServerAccessor;
import team.creative.littletiles.server.level.little.LittleChunkProgressListener;
import team.creative.littletiles.server.level.little.LittleServerChunkCache;
import team.creative.littletiles.server.player.LittleServerPlayerConnection;

public abstract class LittleServerLevel
extends ServerLevel
implements LittleLevel {
    public Entity holder;
    public IVecOrigin origin;
    private final List<LevelBlockChangeListener> blockChangeListeners = new ArrayList<LevelBlockChangeListener>();
    public boolean hasChanged = false;
    public boolean preventNeighborUpdate = false;

    private static LevelStem overworldStem(MinecraftServer server) {
        Registry registry = server.registries().compositeAccess().registryOrThrow(Registries.LEVEL_STEM);
        return (LevelStem)registry.get(LevelStem.OVERWORLD);
    }

    protected LittleServerLevel(MinecraftServer server, ServerLevelData worldInfo, ResourceKey<Level> dimension, boolean debug, long seed, RegistryAccess access) {
        super(server, (Executor)Util.backgroundExecutor(), ((MinecraftServerAccessor)server).getStorageSource(), worldInfo, dimension, LittleServerLevel.overworldStem(server), (ChunkProgressListener)LittleChunkProgressListener.INSTANCE, debug, seed, Collections.EMPTY_LIST, false, null);
    }

    @Override
    public void removeEntityById(int id, Entity.RemovalReason reason) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleEntityRenderManager getRenderManager() {
        return null;
    }

    @Override
    public Entity getHolder() {
        return this.holder;
    }

    @Override
    public void setHolder(Entity entity) {
        this.holder = entity;
    }

    @Override
    public void registerBlockChangeListener(LevelBlockChangeListener listener) {
        this.blockChangeListeners.add(listener);
    }

    public void neighborChanged(BlockPos pos, Block block, BlockPos fromPos) {
        if (this.preventNeighborUpdate) {
            return;
        }
        if (this.isClientSide) {
            BlockState blockstate = this.getBlockState(pos);
            try {
                blockstate.handleNeighborChanged((Level)this, pos, block, fromPos, false);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Block being updated");
                crashreportcategory.setDetail("Source block type", () -> {
                    try {
                        return String.format("ID #%s (%s // %s)", BuiltInRegistries.BLOCK.getKey((Object)block), block.getDescriptionId(), block.getClass().getCanonicalName());
                    }
                    catch (Throwable throwable1) {
                        return "ID #" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)block));
                    }
                });
                CrashReportCategory.populateBlockDetails((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)this, (BlockPos)pos, (BlockState)blockstate);
                throw new ReportedException(crashreport);
            }
        } else {
            super.neighborChanged(pos, block, fromPos);
        }
    }

    public void updateNeighborsAtExceptFromFacing(BlockPos pos, Block block, Direction facing) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.updateNeighborsAtExceptFromFacing(pos, block, facing);
    }

    public void updateNeighborsAt(BlockPos pos, Block block) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.updateNeighborsAt(pos, block);
    }

    public void setBlocksDirty(BlockPos pos, BlockState actualState, BlockState setState) {
        this.blockChangeListeners.forEach(x -> x.blockChanged(pos, setState));
    }

    public LittleServerChunkCache getChunkSource() {
        return (LittleServerChunkCache)super.getChunkSource();
    }

    @Override
    public void unload(LevelChunk chunk) {
        super.unload(chunk);
        this.getChunkSource().getLightEngine().setLightEnabled(chunk.getPos(), false);
    }

    @Override
    public void unload() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MapId getFreeMapId() {
        return new MapId(0);
    }

    @Override
    public Iterable<Entity> entities() {
        return this.getEntities().getAll();
    }

    @Override
    public void tick() {
        while (this.getChunkSource().pollTask()) {
        }
        this.tick(((MinecraftServerAccessor)this.getServer())::callHaveTime);
    }

    public void load(ChunkPos pos, CompoundTag nbt) {
        this.getChunkSource().loadLevelChunk(pos, nbt);
    }

    @Override
    public Iterable<? extends ChunkAccess> chunks() {
        return this.getChunkSource().all();
    }

    public void destroyBlockProgress(int id, BlockPos pos, int progress) {
        LittleServerLevel toCompare = this;
        LittleServerLevel littleServerLevel = this;
        if (littleServerLevel instanceof LittleSubLevel) {
            LittleSubLevel sub = (LittleSubLevel)((Object)littleServerLevel);
            toCompare = sub.getRealLevel();
        }
        for (ServerPlayer serverplayer : this.getServer().getPlayerList().getPlayers()) {
            double d2;
            double d1;
            double d0;
            if (serverplayer == null || serverplayer.level() != toCompare || serverplayer.getId() == id || !((d0 = (double)pos.getX() - serverplayer.getX()) * d0 + (d1 = (double)pos.getY() - serverplayer.getY()) * d1 + (d2 = (double)pos.getZ() - serverplayer.getZ()) * d2 < 1024.0)) continue;
            LittleServerPlayerConnection.send(this, serverplayer, (Packet)new ClientboundBlockDestructionPacket(id, pos, progress));
        }
    }
}

