package team.creative.littletiles.common.placement.mark;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;

import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.placement.PlacementPosition;

@OnlyIn(Dist.CLIENT)
public class MarkMode implements IMarkMode {
    
    public PlacementPosition position = null;
    public boolean allowLowResolution = true;
    
    public MarkMode(Player player, PlacementPosition position) {
        this.position = position;
    }
    
    @Override
    public boolean allowLowResolution() {
        return allowLowResolution;
    }
    
    @Override
    public PlacementPosition getPosition() {
        return position.copy();
    }
    
    @Override
    public void render(LittleGrid positionGrid, PoseStack pose) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        
        RenderSystem.depthMask(true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        
        AABB box = position.getBox().inflate(0.002);
        
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        RenderSystem.lineWidth(4.0F);
        LevelRenderer.renderLineBox(pose, bufferbuilder, box, 0, 0, 0, 1F);
        
        RenderSystem.disableDepthTest();
        RenderSystem.lineWidth(1.0F);
        LevelRenderer.renderLineBox(pose, bufferbuilder, box, 1F, 0.3F, 0.0F, 1F);
        BufferUploader.drawWithShader(bufferbuilder.buildOrThrow());
        RenderSystem.enableDepthTest();
    }
    
    @Override
    public void move(LittleGrid positionGrid, Facing facing) {
        LittleVec vec = new LittleVec(facing.opposite());
        vec.scale(Screen.hasControlDown() ? positionGrid.count : 1);
        position.sub(new LittleVecGrid(vec, positionGrid));
    }
    
    @Override
    public void done() {}
    
}
