/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.sodium.entity;

import java.util.Set;
import net.minecraft.client.renderer.RenderType;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.mod.sodium.buffer.RenderedBufferSodium;
import team.creative.littletiles.client.mod.sodium.entity.LittleSodiumSection;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;

public class CompiledSodiumSection {
    public final LittleSodiumSection section;
    public ChunkLayerMap<RenderedBufferSodium> buffers = new ChunkLayerMap();
    public ChunkLayerMap<BufferCollection> caches = new ChunkLayerMap();

    public CompiledSodiumSection(LittleSodiumSection section) {
        this.section = section;
        LittleRenderPipelineType.startCompile(section);
    }

    public BufferCollection getBuffers(RenderType layer) {
        if (this.caches == null) {
            return null;
        }
        return (BufferCollection)this.caches.get(layer);
    }

    public BufferCollection getOrCreateBuffers(RenderType layer) {
        BufferCollection cache;
        if (this.caches == null) {
            this.caches = new ChunkLayerMap();
        }
        if ((cache = (BufferCollection)this.caches.get(layer)) == null) {
            cache = new BufferCollection();
            this.caches.put(layer, (Object)cache);
        }
        return cache;
    }

    public boolean finish() {
        for (Tuple layer : this.caches.tuples()) {
            this.buffers.put((RenderType)layer.key, (Object)new RenderedBufferSodium((BufferCollection)layer.value));
        }
        LittleRenderPipelineType.endCompile(this.section);
        return !this.buffers.isEmpty();
    }

    public void upload(Set<RenderType> hasBlocks) {
        this.section.upload(this, hasBlocks);
    }
}

