/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.player;

import java.util.BitSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.resources.sounds.GuardianAttackSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundCustomReportDetailsPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ClientboundPingPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPopPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.common.ClientboundServerLinksPacket;
import net.minecraft.network.protocol.common.ClientboundStoreCookiePacket;
import net.minecraft.network.protocol.common.ClientboundTransferPacket;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.cookie.ClientboundCookieRequestPacket;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAddExperienceOrbPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundCooldownPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.ClientboundDebugSamplePacket;
import net.minecraft.network.protocol.game.ClientboundDeleteChatPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.ClientboundRecipePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundTickingStatePacket;
import net.minecraft.network.protocol.game.ClientboundTickingStepPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.level.ClientLevelExtender;
import team.creative.littletiles.client.level.little.LittleClientLevel;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.packet.entity.LittleVanillaPacket;
import team.creative.littletiles.mixin.client.network.ClientPacketListenerAccessor;

public class LittleClientPlayerHandler
implements TickablePacketListener,
ClientGamePacketListener {
    private static final Logger LOGGER = LittleTiles.LOGGER;
    private static final Minecraft mc = Minecraft.getInstance();
    public Level level;

    public LittleClientLevel requiresClientLevel() {
        Level level = this.level;
        if (level instanceof LittleClientLevel) {
            LittleClientLevel s = (LittleClientLevel)level;
            return s;
        }
        throw new RuntimeException("Cannot run this packet on this level " + String.valueOf(this.level));
    }

    public ClientLevelExtender requiresClientLevelExtender() {
        Level level = this.level;
        if (level instanceof ClientLevelExtender) {
            ClientLevelExtender s = (ClientLevelExtender)level;
            return s;
        }
        throw new RuntimeException("Cannot run this packet on this level " + String.valueOf(this.level));
    }

    public void ensureRunningOnSameThread(Packet packet) throws RunningOnDifferentThreadException {
        if (!mc.isSameThread()) {
            mc.executeIfPossible(() -> LittleTilesClient.PLAYER_CONNECTION.runInContext((LittleLevel)this.level, x -> packet.handle((PacketListener)x)));
            throw RunningOnDifferentThreadException.RUNNING_ON_DIFFERENT_THREAD;
        }
    }

    public ClientPacketListener vanilla() {
        return Minecraft.getInstance().getConnection();
    }

    public ClientPacketListenerAccessor vanillaAccessor() {
        return (ClientPacketListenerAccessor)Minecraft.getInstance().getConnection();
    }

    public void handleLogin(ClientboundLoginPacket packet) {
        this.vanilla().handleLogin(packet);
    }

    public void handleDisconnect(ClientboundDisconnectPacket packet) {
        this.vanilla().handleDisconnect(packet);
    }

    public void onDisconnect(DisconnectionDetails details) {
        this.vanilla().onDisconnect(details);
    }

    public void handleRespawn(ClientboundRespawnPacket packet) {
        this.vanilla().handleRespawn(packet);
    }

    public void handleResourcePackPush(ClientboundResourcePackPushPacket packet) {
        this.vanilla().handleResourcePackPush(packet);
    }

    public void handleResourcePackPop(ClientboundResourcePackPopPacket packet) {
        this.vanilla().handleResourcePackPop(packet);
    }

    public void handlePlayerInfoUpdate(ClientboundPlayerInfoUpdatePacket packet) {
        this.vanilla().handlePlayerInfoUpdate(packet);
    }

    public void handlePlayerInfoRemove(ClientboundPlayerInfoRemovePacket packet) {
        this.vanilla().handlePlayerInfoRemove(packet);
    }

    public void handleBlockDestruction(ClientboundBlockDestructionPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        this.level.destroyBlockProgress(packet.getId(), packet.getPos(), packet.getProgress());
    }

    public void handleExplosion(ClientboundExplodePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Explosion explosion = new Explosion(this.level, (Entity)null, packet.getX(), packet.getY(), packet.getZ(), packet.getPower(), packet.getToBlow(), packet.getBlockInteraction(), packet.getSmallExplosionParticles(), packet.getLargeExplosionParticles(), packet.getExplosionSound());
        explosion.finalizeExplosion(true);
        LittleClientPlayerHandler.mc.player.setDeltaMovement(LittleClientPlayerHandler.mc.player.getDeltaMovement().add((double)packet.getKnockbackX(), (double)packet.getKnockbackY(), (double)packet.getKnockbackZ()));
    }

    public void handleBlockEntityData(ClientboundBlockEntityDataPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        BlockPos blockpos = packet.getPos();
        this.level.getBlockEntity(blockpos, packet.getType()).ifPresent(x -> {
            Screen patt0$temp;
            x.onDataPacket(this.vanilla().getConnection(), packet, (HolderLookup.Provider)this.level.registryAccess());
            if (x instanceof CommandBlockEntity && (patt0$temp = LittleClientPlayerHandler.mc.screen) instanceof CommandBlockEditScreen) {
                CommandBlockEditScreen screen = (CommandBlockEditScreen)patt0$temp;
                screen.updateGui();
            }
        });
    }

    public void handleBlockEvent(ClientboundBlockEventPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        this.level.blockEvent(packet.getPos(), packet.getBlock(), packet.getB0(), packet.getB1());
    }

    public void handleLevelEvent(ClientboundLevelEventPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (packet.isGlobalEvent()) {
            this.level.globalLevelEvent(packet.getType(), packet.getPos(), packet.getData());
        } else {
            this.level.levelEvent(packet.getType(), packet.getPos(), packet.getData());
        }
    }

    public void handleSoundEvent(ClientboundSoundPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        this.level.playSeededSound((Player)LittleClientPlayerHandler.mc.player, packet.getX(), packet.getY(), packet.getZ(), packet.getSound(), packet.getSource(), packet.getVolume(), packet.getPitch(), packet.getSeed());
    }

    public void handleSoundEntityEvent(ClientboundSoundEntityPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.getId());
        if (entity != null) {
            this.level.playSeededSound((Player)LittleClientPlayerHandler.mc.player, entity, packet.getSound(), packet.getSource(), packet.getVolume(), packet.getPitch(), packet.getSeed());
        }
    }

    public void send(Packet<?> packet) {
        LittleTiles.NETWORK.sendToServer((CreativePacket)new LittleVanillaPacket((LittleLevel)this.level, packet));
    }

    public void send(Packet<?> packet, @Nullable PacketSendListener listener) {
        this.send(packet);
        if (listener != null) {
            listener.onSuccess();
        }
    }

    @Nullable
    private Entity createEntityFromPacket(ClientboundAddEntityPacket packet) {
        EntityType entitytype = packet.getType();
        if (entitytype == EntityType.PLAYER) {
            PlayerInfo playerinfo = this.vanilla().getPlayerInfo(packet.getUUID());
            if (playerinfo == null) {
                LOGGER.warn("Server attempted to add player prior to sending player info (Player id {})", (Object)packet.getUUID());
                return null;
            }
            return new RemotePlayer((ClientLevel)this.requiresClientLevel(), playerinfo.getProfile());
        }
        return entitytype.create(this.level);
    }

    public void handleAddEntity(ClientboundAddEntityPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = LittleTilesClient.ANIMATION_HANDLER.pollEntityInTransition(packet);
        if (entity == null) {
            entity = this.createEntityFromPacket(packet);
        }
        if (entity != null) {
            entity.recreateFromPacket(packet);
            Level level = this.level;
            if (level instanceof LittleAnimationLevel) {
                LittleAnimationLevel a = (LittleAnimationLevel)level;
                a.addFreshEntityFromPacket(entity);
            } else {
                this.requiresClientLevel().addEntity(entity);
            }
            this.vanillaAccessor().callPostAddEntitySoundInstance(entity);
        } else {
            LOGGER.warn("Skipping Entity with id {}", (Object)packet.getType());
        }
    }

    public void handleAddExperienceOrb(ClientboundAddExperienceOrbPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        ExperienceOrb entity = new ExperienceOrb(this.level, packet.getX(), packet.getY(), packet.getZ(), packet.getValue());
        entity.syncPacketPositionCodec(packet.getX(), packet.getY(), packet.getZ());
        entity.setYRot(0.0f);
        entity.setXRot(0.0f);
        entity.setId(packet.getId());
        level.addEntity((Entity)entity);
    }

    public void handleSetEntityMotion(ClientboundSetEntityMotionPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.getId());
        if (entity != null) {
            entity.lerpMotion(packet.getXa() / 8000.0, packet.getYa() / 8000.0, packet.getZa() / 8000.0);
        }
    }

    public void handleSetEntityData(ClientboundSetEntityDataPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.id());
        if (entity != null) {
            entity.getEntityData().assignValues(packet.packedItems());
        }
    }

    public void handleTeleportEntity(ClientboundTeleportEntityPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.getId());
        if (entity != null) {
            double d0 = packet.getX();
            double d1 = packet.getY();
            double d2 = packet.getZ();
            entity.syncPacketPositionCodec(d0, d1, d2);
            if (!entity.isControlledByLocalInstance()) {
                float f = (float)(packet.getyRot() * 360) / 256.0f;
                float f1 = (float)(packet.getxRot() * 360) / 256.0f;
                entity.lerpTo(d0, d1, d2, f, f1, 3);
                entity.setOnGround(packet.isOnGround());
            }
        }
    }

    public void handleSetCarriedItem(ClientboundSetCarriedItemPacket packet) {
        this.vanilla().handleSetCarriedItem(packet);
    }

    public void handleMoveEntity(ClientboundMoveEntityPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = packet.getEntity(this.level);
        if (entity != null && !entity.isControlledByLocalInstance()) {
            if (packet.hasPosition()) {
                VecDeltaCodec vecdeltacodec = entity.getPositionCodec();
                Vec3 vec3 = vecdeltacodec.decode((long)packet.getXa(), (long)packet.getYa(), (long)packet.getZa());
                vecdeltacodec.setBase(vec3);
                float f = packet.hasRotation() ? (float)(packet.getyRot() * 360) / 256.0f : entity.getYRot();
                float f1 = packet.hasRotation() ? (float)(packet.getxRot() * 360) / 256.0f : entity.getXRot();
                entity.lerpTo(vec3.x(), vec3.y(), vec3.z(), f, f1, 3);
            } else if (packet.hasRotation()) {
                float f2 = (float)(packet.getyRot() * 360) / 256.0f;
                float f3 = (float)(packet.getxRot() * 360) / 256.0f;
                entity.lerpTo(entity.getX(), entity.getY(), entity.getZ(), f2, f3, 3);
            }
            entity.setOnGround(packet.isOnGround());
        }
    }

    public void handleRotateMob(ClientboundRotateHeadPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = packet.getEntity(this.level);
        if (entity != null) {
            float f = (float)(packet.getYHeadRot() * 360) / 256.0f;
            entity.lerpHeadTo(f, 3);
        }
    }

    public void handleRemoveEntities(ClientboundRemoveEntitiesPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        packet.getEntityIds().forEach(id -> ((LittleLevel)this.level).removeEntityById(id, Entity.RemovalReason.DISCARDED));
    }

    public void handleMovePlayer(ClientboundPlayerPositionPacket packet) {
        double d5;
        double d4;
        double d3;
        double d2;
        double d1;
        double d0;
        this.ensureRunningOnSameThread((Packet)packet);
        LocalPlayer player = LittleClientPlayerHandler.mc.player;
        Vec3 vec3 = player.getDeltaMovement();
        boolean flag = packet.getRelativeArguments().contains(RelativeMovement.X);
        boolean flag1 = packet.getRelativeArguments().contains(RelativeMovement.Y);
        boolean flag2 = packet.getRelativeArguments().contains(RelativeMovement.Z);
        if (flag) {
            d0 = vec3.x();
            d1 = player.getX() + packet.getX();
            player.xOld += packet.getX();
            player.xo += packet.getX();
        } else {
            d0 = 0.0;
            player.xOld = d1 = packet.getX();
            player.xo = d1;
        }
        if (flag1) {
            d2 = vec3.y();
            d3 = player.getY() + packet.getY();
            player.yOld += packet.getY();
            player.yo += packet.getY();
        } else {
            d2 = 0.0;
            player.yOld = d3 = packet.getY();
            player.yo = d3;
        }
        if (flag2) {
            d4 = vec3.z();
            d5 = player.getZ() + packet.getZ();
            player.zOld += packet.getZ();
            player.zo += packet.getZ();
        } else {
            d4 = 0.0;
            player.zOld = d5 = packet.getZ();
            player.zo = d5;
        }
        player.setPos(d1, d3, d5);
        player.setDeltaMovement(d0, d2, d4);
        float f = packet.getYRot();
        float f1 = packet.getXRot();
        if (packet.getRelativeArguments().contains(RelativeMovement.X_ROT)) {
            player.setXRot(player.getXRot() + f1);
            player.xRotO += f1;
        } else {
            player.setXRot(f1);
            player.xRotO = f1;
        }
        if (packet.getRelativeArguments().contains(RelativeMovement.Y_ROT)) {
            player.setYRot(player.getYRot() + f);
            player.yRotO += f;
        } else {
            player.setYRot(f);
            player.yRotO = f;
        }
        this.send((Packet<?>)new ServerboundAcceptTeleportationPacket(packet.getId()));
        this.send((Packet<?>)new ServerboundMovePlayerPacket.PosRot(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot(), false));
    }

    public void handleChunkBlocksUpdate(ClientboundSectionBlocksUpdatePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        packet.runUpdates((p_205524_, p_205525_) -> level.setServerVerifiedBlockState((BlockPos)p_205524_, (BlockState)p_205525_, 19));
    }

    public void handleLevelChunkWithLight(ClientboundLevelChunkWithLightPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        this.updateLevelChunk(level, packet.getX(), packet.getZ(), packet.getChunkData());
        this.queueLightUpdate(level, packet.getX(), packet.getZ(), packet.getLightData());
    }

    public void handleChunksBiomes(ClientboundChunksBiomesPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        for (ClientboundChunksBiomesPacket.ChunkBiomeData clientboundchunksbiomespacket$chunkbiomedata : packet.chunkBiomeData()) {
            level.getChunkSource().replaceBiomes(clientboundchunksbiomespacket$chunkbiomedata.pos().x, clientboundchunksbiomespacket$chunkbiomedata.pos().z, clientboundchunksbiomespacket$chunkbiomedata.getReadBuffer());
        }
        for (ClientboundChunksBiomesPacket.ChunkBiomeData clientboundchunksbiomespacket$chunkbiomedata1 : packet.chunkBiomeData()) {
            level.onChunkLoaded(new ChunkPos(clientboundchunksbiomespacket$chunkbiomedata1.pos().x, clientboundchunksbiomespacket$chunkbiomedata1.pos().z));
        }
        for (ClientboundChunksBiomesPacket.ChunkBiomeData clientboundchunksbiomespacket$chunkbiomedata2 : packet.chunkBiomeData()) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = this.level.getMinSection(); k < this.level.getMaxSection(); ++k) {
                        level.setSectionDirty(clientboundchunksbiomespacket$chunkbiomedata2.pos().x + i, k, clientboundchunksbiomespacket$chunkbiomedata2.pos().z + j);
                    }
                }
            }
        }
    }

    private void updateLevelChunk(ClientLevel level, int x, int z, ClientboundLevelChunkPacketData data) {
        level.getChunkSource().replaceWithPacketData(x, z, data.getReadBuffer(), data.getHeightmaps(), data.getBlockEntitiesTagsConsumer(x, z));
    }

    private void queueLightUpdate(ClientLevel level, int x, int z, ClientboundLightUpdatePacketData data) {
        level.queueLightUpdate(() -> {
            this.applyLightData(level, x, z, data);
            LevelChunk levelchunk = this.level.getChunkSource().getChunk(x, z, false);
            if (levelchunk != null) {
                this.enableChunkLight(level, levelchunk, x, z);
            }
        });
    }

    private void applyLightData(ClientLevel level, int x, int z, ClientboundLightUpdatePacketData data) {
        LevelLightEngine levellightengine = this.level.getChunkSource().getLightEngine();
        BitSet bitset = data.getSkyYMask();
        BitSet bitset1 = data.getEmptySkyYMask();
        Iterator<byte[]> iterator = data.getSkyUpdates().iterator();
        this.readSectionList(level, x, z, levellightengine, LightLayer.SKY, bitset, bitset1, iterator);
        BitSet bitset2 = data.getBlockYMask();
        BitSet bitset3 = data.getEmptyBlockYMask();
        Iterator<byte[]> iterator1 = data.getBlockUpdates().iterator();
        this.readSectionList(level, x, z, levellightengine, LightLayer.BLOCK, bitset2, bitset3, iterator1);
        levellightengine.setLightEnabled(new ChunkPos(x, z), true);
    }

    private void readSectionList(ClientLevel level, int x, int z, LevelLightEngine light, LightLayer layer, BitSet minSet, BitSet maxSet, Iterator<byte[]> data) {
        for (int i = 0; i < light.getLightSectionCount(); ++i) {
            int j = light.getMinLightSection() + i;
            boolean flag = minSet.get(i);
            boolean flag1 = maxSet.get(i);
            if (!flag && !flag1) continue;
            light.queueSectionData(layer, SectionPos.of((int)x, (int)j, (int)z), flag ? new DataLayer((byte[])data.next().clone()) : new DataLayer());
            level.setSectionDirtyWithNeighbors(x, j, z);
        }
    }

    private void enableChunkLight(ClientLevel level, LevelChunk chunk, int x, int z) {
        LevelLightEngine levellightengine = this.level.getChunkSource().getLightEngine();
        LevelChunkSection[] alevelchunksection = chunk.getSections();
        ChunkPos chunkpos = chunk.getPos();
        for (int i = 0; i < alevelchunksection.length; ++i) {
            LevelChunkSection levelchunksection = alevelchunksection[i];
            int j = this.level.getSectionYFromSectionIndex(i);
            levellightengine.updateSectionStatus(SectionPos.of((ChunkPos)chunkpos, (int)j), levelchunksection.hasOnlyAir());
            level.setSectionDirtyWithNeighbors(x, j, z);
        }
    }

    public void handleForgetLevelChunk(ClientboundForgetLevelChunkPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        ChunkSource chunkSource = this.level.getChunkSource();
        if (chunkSource instanceof ClientChunkCache) {
            ClientChunkCache client = (ClientChunkCache)chunkSource;
            client.drop(packet.pos());
        }
        this.queueLightRemoval(level, packet);
    }

    private void queueLightRemoval(ClientLevel level, ClientboundForgetLevelChunkPacket packet) {
        ChunkPos chunkpos = packet.pos();
        level.queueLightUpdate(() -> {
            LevelLightEngine levellightengine = this.level.getLightEngine();
            levellightengine.setLightEnabled(chunkpos, false);
            for (int i = levellightengine.getMinLightSection(); i < levellightengine.getMaxLightSection(); ++i) {
                SectionPos sectionpos = SectionPos.of((ChunkPos)chunkpos, (int)i);
                levellightengine.queueSectionData(LightLayer.BLOCK, sectionpos, (DataLayer)null);
                levellightengine.queueSectionData(LightLayer.SKY, sectionpos, (DataLayer)null);
            }
            for (int j = this.level.getMinSection(); j < this.level.getMaxSection(); ++j) {
                levellightengine.updateSectionStatus(SectionPos.of((ChunkPos)chunkpos, (int)j), true);
            }
        });
    }

    public void handleBlockUpdate(ClientboundBlockUpdatePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        ClientLevelExtender level = this.requiresClientLevelExtender();
        level.setServerVerifiedBlockStateExtender(packet.getPos(), packet.getBlockState(), 19);
    }

    public void handleTakeItemEntity(ClientboundTakeItemEntityPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        Entity entity = level.getEntity(packet.getItemId());
        LivingEntity livingentity = (LivingEntity)this.level.getEntity(packet.getPlayerId());
        if (livingentity == null) {
            livingentity = LittleClientPlayerHandler.mc.player;
        }
        if (entity != null) {
            RandomSource random = this.vanillaAccessor().getRandom();
            if (entity instanceof ExperienceOrb) {
                level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, (random.nextFloat() - random.nextFloat()) * 0.35f + 0.9f, false);
            } else {
                level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (random.nextFloat() - random.nextFloat()) * 1.4f + 2.0f, false);
            }
            LittleClientPlayerHandler.mc.particleEngine.add((Particle)new ItemPickupParticle(mc.getEntityRenderDispatcher(), mc.renderBuffers(), LittleClientPlayerHandler.mc.level, entity, (Entity)livingentity));
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                ItemStack itemstack = itemEntity.getItem();
                itemstack.shrink(packet.getAmount());
                if (itemstack.isEmpty()) {
                    level.removeEntity(packet.getItemId(), Entity.RemovalReason.DISCARDED);
                }
            } else if (!(entity instanceof ExperienceOrb)) {
                level.removeEntity(packet.getItemId(), Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void handleSystemChat(ClientboundSystemChatPacket packet) {
        this.vanilla().handleSystemChat(packet);
    }

    public void handlePlayerChat(ClientboundPlayerChatPacket packet) {
        this.vanilla().handlePlayerChat(packet);
    }

    public void handleDisguisedChat(ClientboundDisguisedChatPacket packet) {
        this.vanilla().handleDisguisedChat(packet);
    }

    public void handleDeleteChat(ClientboundDeleteChatPacket packet) {
        this.handleDeleteChat(packet);
    }

    public void handleAnimate(ClientboundAnimatePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.getId());
        if (entity != null) {
            if (packet.getAction() == 0) {
                ((LivingEntity)entity).swing(InteractionHand.MAIN_HAND);
            } else if (packet.getAction() == 3) {
                ((LivingEntity)entity).swing(InteractionHand.OFF_HAND);
            } else if (packet.getAction() == 2) {
                ((Player)entity).stopSleepInBed(false, false);
            } else if (packet.getAction() == 4) {
                LittleClientPlayerHandler.mc.particleEngine.createTrackingEmitter(entity, (ParticleOptions)ParticleTypes.CRIT);
            } else if (packet.getAction() == 5) {
                LittleClientPlayerHandler.mc.particleEngine.createTrackingEmitter(entity, (ParticleOptions)ParticleTypes.ENCHANTED_HIT);
            }
        }
    }

    public void handleHurtAnimation(ClientboundHurtAnimationPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.id());
        if (entity != null) {
            entity.animateHurt(packet.yaw());
        }
    }

    public void handleSetTime(ClientboundSetTimePacket packet) {
        this.vanilla().handleSetTime(packet);
    }

    public void handleSetSpawn(ClientboundSetDefaultSpawnPositionPacket packet) {
        this.vanilla().handleSetSpawn(packet);
    }

    public void handleSetEntityPassengersPacket(ClientboundSetPassengersPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.getVehicle());
        if (entity == null) {
            LOGGER.warn("Received passengers for unknown entity");
            return;
        }
        LocalPlayer player = LittleClientPlayerHandler.mc.player;
        boolean flag = entity.hasIndirectPassenger((Entity)player);
        entity.ejectPassengers();
        for (int i : packet.getPassengers()) {
            Entity entity1 = this.level.getEntity(i);
            if (entity1 == null) continue;
            entity1.startRiding(entity, true);
            if (entity1 != player || flag) continue;
            if (entity instanceof Boat) {
                player.yRotO = entity.getYRot();
                player.setYRot(entity.getYRot());
                player.setYHeadRot(entity.getYRot());
            }
            MutableComponent component = Component.translatable((String)"mount.onboard", (Object[])new Object[]{LittleClientPlayerHandler.mc.options.keyShift.getTranslatedKeyMessage()});
            LittleClientPlayerHandler.mc.gui.setOverlayMessage((Component)component, false);
            mc.getNarrator().sayNow((Component)component);
        }
    }

    public void handleEntityLinkPacket(ClientboundSetEntityLinkPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.getSourceId());
        if (entity instanceof Mob) {
            ((Mob)entity).setDelayedLeashHolderId(packet.getDestId());
        }
    }

    private static ItemStack findTotem(Player p_104928_) {
        for (InteractionHand interactionhand : InteractionHand.values()) {
            ItemStack itemstack = p_104928_.getItemInHand(interactionhand);
            if (!itemstack.is(Items.TOTEM_OF_UNDYING)) continue;
            return itemstack;
        }
        return new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING);
    }

    public void handleEntityEvent(ClientboundEntityEventPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = packet.getEntity(this.level);
        if (entity != null) {
            if (packet.getEventId() == 21) {
                mc.getSoundManager().play((SoundInstance)new GuardianAttackSoundInstance((Guardian)entity));
            } else if (packet.getEventId() == 35) {
                LittleClientPlayerHandler.mc.particleEngine.createTrackingEmitter(entity, (ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, 30);
                this.level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TOTEM_USE, entity.getSoundSource(), 1.0f, 1.0f, false);
                if (entity == LittleClientPlayerHandler.mc.player) {
                    LittleClientPlayerHandler.mc.gameRenderer.displayItemActivation(LittleClientPlayerHandler.findTotem((Player)LittleClientPlayerHandler.mc.player));
                }
            } else {
                entity.handleEntityEvent(packet.getEventId());
            }
        }
    }

    public void handleDamageEvent(ClientboundDamageEventPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.entityId());
        if (entity != null) {
            entity.handleDamageEvent(packet.getSource(this.level));
        }
    }

    public void handleSetHealth(ClientboundSetHealthPacket packet) {
        this.vanilla().handleSetHealth(packet);
    }

    public void handleSetExperience(ClientboundSetExperiencePacket packet) {
        this.vanilla().handleSetExperience(packet);
    }

    public void handleHorseScreenOpen(ClientboundHorseScreenOpenPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.getEntityId());
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            LocalPlayer localplayer = LittleClientPlayerHandler.mc.player;
            int i = packet.getInventoryColumns();
            SimpleContainer simplecontainer = new SimpleContainer(AbstractHorse.getInventorySize((int)i));
            HorseInventoryMenu horseinventorymenu = new HorseInventoryMenu(packet.getContainerId(), localplayer.getInventory(), (Container)simplecontainer, horse, i);
            localplayer.containerMenu = horseinventorymenu;
            mc.setScreen((Screen)new HorseInventoryScreen(horseinventorymenu, localplayer.getInventory(), horse, i));
        }
    }

    public void handleOpenScreen(ClientboundOpenScreenPacket packet) {
        this.vanilla().handleOpenScreen(packet);
    }

    public void handleContainerSetSlot(ClientboundContainerSetSlotPacket packet) {
        this.vanilla().handleContainerSetSlot(packet);
    }

    public void handleContainerContent(ClientboundContainerSetContentPacket packet) {
        this.vanilla().handleContainerContent(packet);
    }

    public void handleOpenSignEditor(ClientboundOpenSignEditorPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        BlockPos blockpos = packet.getPos();
        BlockEntity blockentity = this.level.getBlockEntity(blockpos);
        if (!(blockentity instanceof SignBlockEntity)) {
            BlockState blockstate = this.level.getBlockState(blockpos);
            blockentity = new SignBlockEntity(blockpos, blockstate);
            blockentity.setLevel(this.level);
        }
        LittleClientPlayerHandler.mc.player.openTextEdit((SignBlockEntity)blockentity, packet.isFrontText());
    }

    public void handleContainerSetData(ClientboundContainerSetDataPacket packet) {
        this.vanilla().handleContainerSetData(packet);
    }

    public void handleSetEquipment(ClientboundSetEquipmentPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.getEntity());
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            packet.getSlots().forEach(slot -> living.setItemSlot((EquipmentSlot)slot.getFirst(), (ItemStack)slot.getSecond()));
        }
    }

    public void handleContainerClose(ClientboundContainerClosePacket packet) {
        this.vanilla().handleContainerClose(packet);
    }

    public void handleGameEvent(ClientboundGameEventPacket packet) {
        this.vanilla().handleGameEvent(packet);
    }

    public void handleMapItemData(ClientboundMapItemDataPacket packet) {
        this.vanilla().handleMapItemData(packet);
    }

    public void handleUpdateAdvancementsPacket(ClientboundUpdateAdvancementsPacket packet) {
        this.vanilla().handleUpdateAdvancementsPacket(packet);
    }

    public void handleSelectAdvancementsTab(ClientboundSelectAdvancementsTabPacket packet) {
        this.vanilla().handleSelectAdvancementsTab(packet);
    }

    public void handleCommands(ClientboundCommandsPacket packet) {
        this.vanilla().handleCommands(packet);
    }

    public void handleStopSoundEvent(ClientboundStopSoundPacket packet) {
        this.vanilla().handleStopSoundEvent(packet);
    }

    public void handleCommandSuggestions(ClientboundCommandSuggestionsPacket packet) {
        this.vanilla().handleCommandSuggestions(packet);
    }

    public void handleUpdateRecipes(ClientboundUpdateRecipesPacket packet) {
        this.vanilla().handleUpdateRecipes(packet);
    }

    public void handleLookAt(ClientboundPlayerLookAtPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Vec3 vec3 = packet.getPosition(this.level);
        if (vec3 != null) {
            LittleClientPlayerHandler.mc.player.lookAt(packet.getFromAnchor(), vec3);
        }
    }

    public void handleTagQueryPacket(ClientboundTagQueryPacket packet) {
        this.vanilla().handleTagQueryPacket(packet);
    }

    public void handleAwardStats(ClientboundAwardStatsPacket packet) {
        this.vanilla().handleAwardStats(packet);
    }

    public void handleAddOrRemoveRecipes(ClientboundRecipePacket packet) {
        this.vanilla().handleAddOrRemoveRecipes(packet);
    }

    public void handleUpdateMobEffect(ClientboundUpdateMobEffectPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.getEntityId());
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Holder mobeffect = packet.getEffect();
            MobEffectInstance instance = new MobEffectInstance(mobeffect, packet.getEffectDurationTicks(), packet.getEffectAmplifier(), packet.isEffectAmbient(), packet.isEffectVisible(), packet.effectShowsIcon(), (MobEffectInstance)null);
            if (!packet.shouldBlend()) {
                instance.skipBlending();
            }
            living.forceAddEffect(instance, (Entity)null);
        }
    }

    public void handleUpdateTags(ClientboundUpdateTagsPacket packet) {
        this.vanilla().handleUpdateTags(packet);
    }

    public void handlePlayerCombatEnd(ClientboundPlayerCombatEndPacket packet) {
    }

    public void handlePlayerCombatEnter(ClientboundPlayerCombatEnterPacket packet) {
    }

    public void handlePlayerCombatKill(ClientboundPlayerCombatKillPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.playerId());
        if (entity == LittleClientPlayerHandler.mc.player) {
            if (LittleClientPlayerHandler.mc.player.shouldShowDeathScreen()) {
                mc.setScreen((Screen)new DeathScreen(packet.message(), this.level.getLevelData().isHardcore()));
            } else {
                LittleClientPlayerHandler.mc.player.respawn();
            }
        }
    }

    public void handleChangeDifficulty(ClientboundChangeDifficultyPacket packet) {
        this.vanilla().handleChangeDifficulty(packet);
    }

    public void handleSetCamera(ClientboundSetCameraPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = packet.getEntity(this.level);
        if (entity != null) {
            mc.setCameraEntity(entity);
        }
    }

    public void handleInitializeBorder(ClientboundInitializeBorderPacket packet) {
        this.vanilla().handleInitializeBorder(packet);
    }

    public void handleSetBorderCenter(ClientboundSetBorderCenterPacket packet) {
        this.vanilla().handleSetBorderCenter(packet);
    }

    public void handleSetBorderLerpSize(ClientboundSetBorderLerpSizePacket packet) {
        this.vanilla().handleSetBorderLerpSize(packet);
    }

    public void handleSetBorderSize(ClientboundSetBorderSizePacket packet) {
        this.vanilla().handleSetBorderSize(packet);
    }

    public void handleSetBorderWarningDistance(ClientboundSetBorderWarningDistancePacket packet) {
        this.vanilla().handleSetBorderWarningDistance(packet);
    }

    public void handleSetBorderWarningDelay(ClientboundSetBorderWarningDelayPacket packet) {
        this.vanilla().handleSetBorderWarningDelay(packet);
    }

    public void handleTitlesClear(ClientboundClearTitlesPacket packet) {
        this.vanilla().handleTitlesClear(packet);
    }

    public void handleServerData(ClientboundServerDataPacket packet) {
        this.vanilla().handleServerData(packet);
    }

    public void handleCustomChatCompletions(ClientboundCustomChatCompletionsPacket packet) {
        this.vanilla().handleCustomChatCompletions(packet);
    }

    public void setActionBarText(ClientboundSetActionBarTextPacket packet) {
        this.vanilla().setActionBarText(packet);
    }

    public void setTitleText(ClientboundSetTitleTextPacket packet) {
        this.vanilla().setTitleText(packet);
    }

    public void setSubtitleText(ClientboundSetSubtitleTextPacket packet) {
        this.vanilla().setSubtitleText(packet);
    }

    public void setTitlesAnimation(ClientboundSetTitlesAnimationPacket packet) {
        this.vanilla().setTitlesAnimation(packet);
    }

    public void handleTabListCustomisation(ClientboundTabListPacket packet) {
        this.vanilla().handleTabListCustomisation(packet);
    }

    public void handleRemoveMobEffect(ClientboundRemoveMobEffectPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = packet.getEntity(this.level);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.removeEffectNoUpdate(packet.effect());
        }
    }

    public void handleKeepAlive(ClientboundKeepAlivePacket packet) {
        this.vanilla().handleKeepAlive(packet);
    }

    public void handlePlayerAbilities(ClientboundPlayerAbilitiesPacket packet) {
        this.vanilla().handlePlayerAbilities(packet);
    }

    public void handleBossUpdate(ClientboundBossEventPacket packet) {
        this.vanilla().handleBossUpdate(packet);
    }

    public void handleItemCooldown(ClientboundCooldownPacket packet) {
        this.vanilla().handleItemCooldown(packet);
    }

    public void handleMoveVehicle(ClientboundMoveVehiclePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = LittleClientPlayerHandler.mc.player.getRootVehicle();
        if (entity != LittleClientPlayerHandler.mc.player && entity.isControlledByLocalInstance()) {
            entity.absMoveTo(packet.getX(), packet.getY(), packet.getZ(), packet.getYRot(), packet.getXRot());
            this.send((Packet<?>)new ServerboundMoveVehiclePacket(entity));
        }
    }

    public void handleOpenBook(ClientboundOpenBookPacket packet) {
        this.vanilla().handleOpenBook(packet);
    }

    public void handleCustomPayload(ClientboundCustomPayloadPacket packet) {
        this.vanilla().handleCustomPayload(packet);
    }

    public void handleAddObjective(ClientboundSetObjectivePacket packet) {
        this.vanilla().handleAddObjective(packet);
    }

    public void handleSetScore(ClientboundSetScorePacket packet) {
        this.vanilla().handleSetScore(packet);
    }

    public void handleSetDisplayObjective(ClientboundSetDisplayObjectivePacket packet) {
        this.vanilla().handleSetDisplayObjective(packet);
    }

    public void handleSetPlayerTeamPacket(ClientboundSetPlayerTeamPacket packet) {
        this.vanilla().handleSetPlayerTeamPacket(packet);
    }

    public void handleParticleEvent(ClientboundLevelParticlesPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (packet.getCount() == 0) {
            double d0 = packet.getMaxSpeed() * packet.getXDist();
            double d2 = packet.getMaxSpeed() * packet.getYDist();
            double d4 = packet.getMaxSpeed() * packet.getZDist();
            try {
                this.level.addParticle(packet.getParticle(), packet.isOverrideLimiter(), packet.getX(), packet.getY(), packet.getZ(), d0, d2, d4);
            }
            catch (Throwable throwable1) {
                LOGGER.warn("Could not spawn particle effect {}", (Object)packet.getParticle());
            }
        } else {
            RandomSource random = this.vanillaAccessor().getRandom();
            for (int i = 0; i < packet.getCount(); ++i) {
                double d1 = random.nextGaussian() * (double)packet.getXDist();
                double d3 = random.nextGaussian() * (double)packet.getYDist();
                double d5 = random.nextGaussian() * (double)packet.getZDist();
                double d6 = random.nextGaussian() * (double)packet.getMaxSpeed();
                double d7 = random.nextGaussian() * (double)packet.getMaxSpeed();
                double d8 = random.nextGaussian() * (double)packet.getMaxSpeed();
                try {
                    this.level.addParticle(packet.getParticle(), packet.isOverrideLimiter(), packet.getX() + d1, packet.getY() + d3, packet.getZ() + d5, d6, d7, d8);
                    continue;
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not spawn particle effect {}", (Object)packet.getParticle());
                    return;
                }
            }
        }
    }

    public void handlePing(ClientboundPingPacket packet) {
        this.vanilla().handlePing(packet);
    }

    public void handleUpdateAttributes(ClientboundUpdateAttributesPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        Entity entity = this.level.getEntity(packet.getEntityId());
        if (entity != null) {
            if (!(entity instanceof LivingEntity)) {
                throw new IllegalStateException("Server tried to update attributes of a non-living entity (actually: " + String.valueOf(entity) + ")");
            }
            AttributeMap attributemap = ((LivingEntity)entity).getAttributes();
            for (ClientboundUpdateAttributesPacket.AttributeSnapshot attribute : packet.getValues()) {
                AttributeInstance attributeinstance = attributemap.getInstance(attribute.attribute());
                if (attributeinstance == null) {
                    LOGGER.warn("Entity {} does not have attribute {}", (Object)entity, (Object)attribute.attribute().getRegisteredName());
                    continue;
                }
                attributeinstance.setBaseValue(attribute.base());
                attributeinstance.removeModifiers();
                for (AttributeModifier attributemodifier : attribute.modifiers()) {
                    attributeinstance.addTransientModifier(attributemodifier);
                }
            }
        }
    }

    public void handlePlaceRecipe(ClientboundPlaceGhostRecipePacket packet) {
        this.vanilla().handlePlaceRecipe(packet);
    }

    public void handleLightUpdatePacket(ClientboundLightUpdatePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        LittleClientLevel level = this.requiresClientLevel();
        level.queueLightUpdate(() -> this.vanillaAccessor().callApplyLightData(packet.getX(), packet.getZ(), packet.getLightData()));
    }

    public void handleMerchantOffers(ClientboundMerchantOffersPacket packet) {
        this.vanilla().handleMerchantOffers(packet);
    }

    public void handleSetChunkCacheRadius(ClientboundSetChunkCacheRadiusPacket packet) {
        this.vanilla().handleSetChunkCacheRadius(packet);
    }

    public void handleSetSimulationDistance(ClientboundSetSimulationDistancePacket packet) {
        this.vanilla().handleSetSimulationDistance(packet);
    }

    public void handleSetChunkCacheCenter(ClientboundSetChunkCacheCenterPacket packet) {
        this.vanilla().handleSetChunkCacheCenter(packet);
    }

    public void handleBundlePacket(ClientboundBundlePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        for (Packet sub : packet.subPackets()) {
            sub.handle((PacketListener)this);
        }
    }

    public void handleBlockChangedAck(ClientboundBlockChangedAckPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        ClientLevelExtender level = this.requiresClientLevelExtender();
        level.handleBlockChangedAckExtender(packet.sequence());
    }

    public void tick() {
    }

    public boolean isAcceptingMessages() {
        return this.vanilla().isAcceptingMessages();
    }

    public void handlePongResponse(ClientboundPongResponsePacket packet) {
        this.vanilla().handlePongResponse(packet);
    }

    public void handleStoreCookie(ClientboundStoreCookiePacket packet) {
        this.vanilla().handleStoreCookie(packet);
    }

    public void handleTransfer(ClientboundTransferPacket packet) {
        this.vanilla().handleTransfer(packet);
    }

    public void handleCustomReportDetails(ClientboundCustomReportDetailsPacket packet) {
        this.vanilla().handleCustomReportDetails(packet);
    }

    public void handleServerLinks(ClientboundServerLinksPacket packet) {
        this.vanilla().handleServerLinks(packet);
    }

    public void handleRequestCookie(ClientboundCookieRequestPacket packet) {
        this.vanilla().handleRequestCookie(packet);
    }

    public Connection getConnection() {
        return this.vanilla().getConnection();
    }

    public ConnectionType getConnectionType() {
        return this.vanilla().getConnectionType();
    }

    public void handleResetScore(ClientboundResetScorePacket packet) {
        this.vanilla().handleResetScore(packet);
    }

    public void handleTickingState(ClientboundTickingStatePacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        TickRateManager tickratemanager = this.level.tickRateManager();
        tickratemanager.setTickRate(packet.tickRate());
        tickratemanager.setFrozen(packet.isFrozen());
    }

    public void handleTickingStep(ClientboundTickingStepPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (this.level != null) {
            TickRateManager tickratemanager = this.level.tickRateManager();
            tickratemanager.setFrozenTicksToRun(packet.tickSteps());
        }
    }

    public void handleConfigurationStart(ClientboundStartConfigurationPacket packet) {
        this.vanilla().handleConfigurationStart(packet);
    }

    public void handleChunkBatchStart(ClientboundChunkBatchStartPacket packet) {
        this.vanilla().handleChunkBatchStart(packet);
    }

    public void handleChunkBatchFinished(ClientboundChunkBatchFinishedPacket packet) {
        this.vanilla().handleChunkBatchFinished(packet);
    }

    public void handleDebugSample(ClientboundDebugSamplePacket packet) {
        this.vanilla().handleDebugSample(packet);
    }

    public void handleProjectilePowerPacket(ClientboundProjectilePowerPacket packet) {
        Entity entity = this.level.getEntity(packet.getId());
        if (entity instanceof AbstractHurtingProjectile) {
            AbstractHurtingProjectile abstracthurtingprojectile = (AbstractHurtingProjectile)entity;
            abstracthurtingprojectile.accelerationPower = packet.getAccelerationPower();
        }
    }
}

