/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.build;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.world.level.Level;
import team.creative.littletiles.client.render.cache.build.RenderingBlockContext;
import team.creative.littletiles.client.render.cache.build.RenderingLevelHandler;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;

public class RenderingBlockQueue {
    private ConcurrentLinkedQueue<RenderingBlockContext> queue = new ConcurrentLinkedQueue();
    private Object2ObjectMap<Level, Long2IntMap> levels = new Object2ObjectOpenHashMap();

    public void requeue(RenderingBlockContext context) {
        this.queue.add(context);
    }

    public synchronized void queue(BETiles tiles, boolean hasPos, long pos) {
        Level level = tiles.getLevel();
        RenderingLevelHandler handler = RenderingLevelHandler.of(level);
        RenderingBlockContext context = new RenderingBlockContext(tiles, hasPos, pos, handler);
        Long2IntMap sections = (Long2IntMap)this.levels.computeIfAbsent((Object)level, x -> new Long2IntOpenHashMap());
        pos = context.queuedSection();
        int count = sections.getOrDefault(pos, 0);
        sections.put(pos, ++count);
        this.queue.add(context);
    }

    public synchronized RenderChunkExtender unqeue(RenderingBlockContext context) {
        Level level = context.getLevel();
        Long2IntMap sections = (Long2IntMap)this.levels.get((Object)level);
        if (sections == null) {
            return null;
        }
        long pos = context.queuedSection();
        int count = sections.get(pos);
        if (--count <= 0) {
            sections.remove(pos);
            if (sections.isEmpty()) {
                this.levels.remove((Object)level);
            }
            return context.getRenderChunk();
        }
        sections.put(pos, count);
        return null;
    }

    public RenderingBlockContext poll() {
        return this.queue.poll();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int levelCount() {
        return this.levels.size();
    }

    public int sectionCount() {
        int sections = 0;
        for (Long2IntMap map : this.levels.values()) {
            sections += map.size();
        }
        return sections;
    }

    public int size() {
        return this.queue.size();
    }

    public void clear() {
        this.levels.clear();
        this.queue.clear();
    }
}

