/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.pipeline;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.lighting.QuadLighter;
import team.creative.creativecore.client.render.model.CreativeQuadLighter;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.creativecore.common.util.type.map.ChunkLayerMapList;
import team.creative.creativecore.mixin.ForgeModelBlockRendererAccessor;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferHolder;
import team.creative.littletiles.client.render.cache.build.RenderingBlockContext;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipeline;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.mixin.client.render.BufferBuilderAccessor;

@OnlyIn(value=Dist.CLIENT)
public class LittleRenderPipelineForge
extends LittleRenderPipeline {
    private final ChunkLayerMap<ByteBufferBuilder> byteBuilder = new ChunkLayerMap();
    private final ChunkLayerMap<IntArrayList> indexes = new ChunkLayerMap(layer -> new IntArrayList());
    private final BlockPos.MutableBlockPos modelOffset = new BlockPos.MutableBlockPos();

    private ByteBufferBuilder getOrCreate(RenderType layer) {
        ByteBufferBuilder buffer = (ByteBufferBuilder)this.byteBuilder.get(layer);
        if (buffer == null) {
            buffer = new ByteBufferBuilder(layer.bufferSize());
            this.byteBuilder.put(layer, (Object)buffer);
        }
        return buffer;
    }

    private void clearIndexes() {
        for (IntArrayList list : this.indexes) {
            list.clear();
        }
    }

    @Override
    public void buildCache(PoseStack pose, ChunkLayerMap<BufferCache> buffers, RenderingBlockContext data, VertexFormat format, SingletonList<BakedQuad> bakedQuadWrapper) {
        LittleSubLevel sub;
        Level renderLevel = data.be.getLevel();
        while (renderLevel instanceof LittleSubLevel && !(sub = (LittleSubLevel)renderLevel).shouldUseLightingForRenderig()) {
            renderLevel = sub.getParent();
        }
        BlockPos pos = data.be.getBlockPos();
        ForgeModelBlockRendererAccessor renderer = (ForgeModelBlockRendererAccessor)MC.getBlockRenderer().getModelRenderer();
        boolean smooth = Minecraft.useAmbientOcclusion() && data.state.getLightEmission((BlockGetter)data.be.getLevel(), pos) == 0;
        QuadLighter lighter = smooth ? (QuadLighter)renderer.getSmoothLighter().get() : (QuadLighter)renderer.getFlatLighter().get();
        lighter.setup((BlockAndTintGetter)renderLevel, pos, data.state);
        int overlay = OverlayTexture.NO_OVERLAY;
        data.prepareModelOffset(this.modelOffset, pos);
        pose.translate((float)this.modelOffset.getX(), (float)this.modelOffset.getY(), (float)this.modelOffset.getZ());
        ChunkLayerMap builders = new ChunkLayerMap();
        for (Int2ObjectMap.Entry entry : data.be.render.cachedBoxes().int2ObjectEntrySet()) {
            ChunkLayerMapList structureMap = (ChunkLayerMapList)entry.getValue();
            if (structureMap == null || structureMap.isEmpty()) continue;
            for (Tuple tuple : structureMap.tuples()) {
                List cubes = (List)tuple.value;
                if (cubes.isEmpty()) continue;
                BufferBuilder builder = (BufferBuilder)builders.get((RenderType)tuple.key);
                if (builder == null) {
                    builder = new BufferBuilder(this.getOrCreate((RenderType)tuple.key), VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
                    builders.put((RenderType)tuple.key, (Object)builder);
                }
                for (LittleRenderBox cube : cubes) {
                    BlockState state = cube.state;
                    ((CreativeQuadLighter)lighter).setState(state);
                    ((CreativeQuadLighter)lighter).setCustomTint(cube.color);
                    for (int h = 0; h < Facing.VALUES.length; ++h) {
                        Facing facing = Facing.VALUES[h];
                        Object quadObject = cube.getQuad(facing);
                        SingletonList<BakedQuad> quads = null;
                        if (quadObject instanceof List) {
                            SingletonList<BakedQuad> q;
                            quads = q = (SingletonList<BakedQuad>)quadObject;
                        } else if (quadObject instanceof BakedQuad) {
                            BakedQuad quad = (BakedQuad)quadObject;
                            bakedQuadWrapper.setElement((Object)quad);
                            quads = bakedQuadWrapper;
                        }
                        if (quads == null || quads.isEmpty()) continue;
                        if (quads instanceof SingletonList) {
                            SingletonList<BakedQuad> single = quads;
                            lighter.process((VertexConsumer)builder, pose.last(), (BakedQuad)single.get(0), overlay);
                            continue;
                        }
                        for (BakedQuad quad : quads) {
                            lighter.process((VertexConsumer)builder, pose.last(), quad, overlay);
                        }
                    }
                    bakedQuadWrapper.setElement(null);
                    if (LittleTiles.CONFIG.rendering.useQuadCache) continue;
                    cube.deleteQuadCache();
                }
                IntArrayList indexList = (IntArrayList)this.indexes.get((RenderType)tuple.key);
                indexList.add(entry.getIntKey());
                indexList.add(((BufferBuilderAccessor)builder).getVertices() * format.getVertexSize());
            }
        }
        for (RenderType layer : RenderType.CHUNK_BUFFER_LAYERS) {
            MeshData mesh;
            BufferBuilder builder = (BufferBuilder)builders.get(layer);
            if (builder == null || (mesh = builder.build()) == null) continue;
            buffers.put(layer, (Object)new BufferHolder(mesh, ((IntArrayList)this.indexes.get(layer)).toIntArray()));
        }
        this.clearIndexes();
        ((CreativeQuadLighter)lighter).setCustomTint(-1);
        lighter.reset();
    }

    @Override
    public void reload() {
    }

    @Override
    public void release() {
    }
}

