/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.level;

import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.littletiles.client.render.level.RenderAdditional;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;

@OnlyIn(value=Dist.CLIENT)
public class RenderUploader {
    private static final HashMap<Level, RenderAdditional> CACHES = new HashMap();

    private static RenderAdditional getOrCreate(Level level) {
        RenderAdditional data = CACHES.get(level);
        if (data == null) {
            data = new RenderAdditional(level);
            CACHES.put(level, data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queue(Level targetLevel, LittleAnimationEntity entity) {
        HashMap<Level, RenderAdditional> hashMap = CACHES;
        synchronized (hashMap) {
            if (RenderUploader.getOrCreate(targetLevel).queue(entity.getUUID(), entity.getSubLevel(), entity.getSubLevel())) {
                CACHES.remove(entity.getSubLevel());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyReceiveClientUpdate(BETiles be) {
        if (CACHES.isEmpty()) {
            return;
        }
        HashMap<Level, RenderAdditional> hashMap = CACHES;
        synchronized (hashMap) {
            RenderAdditional data = CACHES.get(be.getLevel());
            if (data != null && data.notifyReceiveClientUpdate(be)) {
                CACHES.remove(be.getLevel());
            }
        }
    }

    public static void unload() {
        CACHES.clear();
    }

    public static void longTick(int index) {
        Iterator<RenderAdditional> iterator = CACHES.values().iterator();
        while (iterator.hasNext()) {
            RenderAdditional level = iterator.next();
            if (!level.longTick(index)) continue;
            iterator.remove();
        }
    }
}

