/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.overlay;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.render.cache.build.RenderingThread;

public class LittleTilesProfilerOverlay {
    private static boolean showDebugInfo = false;
    public static int chunkUpdates = 0;
    public static int uploaded = 0;
    private static int updateTime = 20;
    private static int updateTicker = 0;
    private static List<Long> durations;
    private static long averageDuration;
    private static DecimalFormat df;
    private static Minecraft mc;

    public static boolean isActive() {
        return showDebugInfo;
    }

    private static String format(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return df.format(value);
        }
        return value.toString();
    }

    private static String format(PairList<String, Object> details) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Pair pair : details) {
            if (!first) {
                builder.append(",");
            } else {
                first = false;
            }
            builder.append(String.valueOf(ChatFormatting.YELLOW) + (String)pair.key + String.valueOf(ChatFormatting.RESET) + ":" + LittleTilesProfilerOverlay.format(pair.value));
        }
        return builder.toString();
    }

    public static void start() {
        durations = new ArrayList<Long>();
        showDebugInfo = true;
    }

    public static void stop() {
        durations = null;
        showDebugInfo = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishBuildingCache(long duration) {
        List<Long> list = durations;
        synchronized (list) {
            durations.add(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onTick(ClientTickEvent.Post event) {
        if (++updateTicker > updateTime) {
            chunkUpdates = 0;
            uploaded = 0;
            updateTicker = 0;
            if (durations != null) {
                List<Long> list = durations;
                synchronized (list) {
                    averageDuration = 0L;
                    if (!durations.isEmpty()) {
                        for (int i = 0; i < durations.size(); ++i) {
                            averageDuration += durations.get(i).longValue();
                        }
                        averageDuration /= (long)durations.size();
                        durations.clear();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRender(RenderGuiEvent.Post event) {
        if (!mc.isPaused() && !LittleTilesProfilerOverlay.mc.options.hideGui && LittleTilesProfilerOverlay.mc.level != null && RenderingThread.THREADS != null) {
            RenderSystem.defaultBlendFunc();
            GuiGraphics graphics = event.getGuiGraphics();
            ArrayList warnings = new ArrayList();
            if (!warnings.isEmpty()) {
                for (int i = 0; i < warnings.size(); ++i) {
                    String warning = (String)warnings.get(i);
                    int k = LittleTilesProfilerOverlay.mc.font.width(warning);
                    Objects.requireNonNull(LittleTilesProfilerOverlay.mc.font);
                    int i1 = 2 + 9 * i;
                    Objects.requireNonNull(LittleTilesProfilerOverlay.mc.font);
                    graphics.fill(1, i1 - 1, 2 + k + 1, i1 + 9 - 1, -1873784752);
                    graphics.drawString(LittleTilesProfilerOverlay.mc.font, warning, 2, i1, 0xE0E0E0);
                }
            }
            if (showDebugInfo) {
                ArrayList<String> list = new ArrayList<String>();
                PairList details = new PairList();
                details.add((Object)"ThreadCount", (Object)RenderingThread.THREADS.size());
                details.add((Object)"Levels", (Object)RenderingThread.QUEUE.levelCount());
                details.add((Object)"Sections", (Object)RenderingThread.QUEUE.sectionCount());
                details.add((Object)"Triggered", (Object)(uploaded + chunkUpdates));
                details.add((Object)"Queue", (Object)RenderingThread.queueSize());
                if (averageDuration > 1000L) {
                    details.add((Object)"Average", (Object)(averageDuration / 1000L + "ms"));
                } else {
                    details.add((Object)"Average", (Object)(averageDuration + "ns"));
                }
                list.add(LittleTilesProfilerOverlay.format((PairList<String, Object>)details));
                details.clear();
                details.add((Object)"Item Cache", (Object)LittleTilesClient.ITEM_RENDER_CACHE.countCaches());
                list.add(LittleTilesProfilerOverlay.format((PairList<String, Object>)details));
                details.clear();
                for (int i = 0; i < list.size(); ++i) {
                    String s = (String)list.get(i);
                    if (Strings.isNullOrEmpty((String)s)) continue;
                    Objects.requireNonNull(LittleTilesProfilerOverlay.mc.font);
                    int j = 9;
                    int k = LittleTilesProfilerOverlay.mc.font.width(s);
                    int i1 = 2 + j * i;
                    graphics.fill(1, i1 - 1, 2 + k + 1, i1 + j - 1, -1873784752);
                    graphics.drawString(LittleTilesProfilerOverlay.mc.font, s, 2, i1, 0xE0E0E0);
                }
            }
        }
    }

    static {
        df = new DecimalFormat("0.##");
        mc = Minecraft.getInstance();
    }
}

