/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.littletiles.common.structure.type.premade.LittleParticleEmitter;
import team.creative.littletiles.mixin.client.render.ParticleEngineAccessor;

@OnlyIn(value=Dist.CLIENT)
public class LittleParticle
extends TextureSheetParticle {
    private static final Minecraft mc = Minecraft.getInstance();
    public LittleParticleEmitter.ParticleSettings settings;
    public SpriteSet sprites;
    private float scaleDeviation;

    public LittleParticle(ClientLevel level, Vec3d pos, Vec3d speed, LittleParticleEmitter.ParticleSettings settings) {
        super(level, pos.x, pos.y, pos.z);
        this.xd = speed.x * (Math.random() * 0.1 + 0.95);
        this.yd = speed.y * (Math.random() * 0.1 + 0.95);
        this.zd = speed.z * (Math.random() * 0.1 + 0.95);
        this.lifetime = (int)((double)settings.lifetime + (double)settings.lifetimeDeviation * Math.random());
        this.gravity = settings.gravity;
        this.alpha = ColorUtils.alphaF((int)settings.color);
        this.rCol = ColorUtils.redF((int)settings.color);
        this.gCol = ColorUtils.greenF((int)settings.color);
        this.bCol = ColorUtils.blueF((int)settings.color);
        if (settings.randomColor) {
            this.rCol = (float)((double)this.rCol * Math.random());
            this.gCol = (float)((double)this.gCol * Math.random());
            this.bCol = (float)((double)this.bCol * Math.random());
        }
        this.hasPhysics = settings.collision;
        this.settings = settings;
        this.sprites = ((ParticleEngineAccessor)LittleParticle.mc.particleEngine).getSpriteSets().get(settings.texture.particleTexture);
        this.scaleDeviation = (float)(Math.random() * (double)settings.sizeDeviation);
        settings.texture.init(this);
        settings.texture.tick(this);
        this.setSize(0.2f * settings.startSize, 0.2f * settings.startSize);
    }

    public void tick() {
        this.settings.texture.tick(this);
        float lifePercentage = (float)this.getAge() / (float)this.getMaxAge();
        this.quadSize = this.scaleDeviation + lifePercentage * (this.settings.endSize - this.settings.startSize) + this.settings.startSize;
        super.tick();
    }

    public int getAge() {
        return this.age;
    }

    public int getMaxAge() {
        return this.lifetime;
    }

    public void setSpriteFirst(SpriteSet set) {
        this.setSprite(set.get(0, this.lifetime));
    }

    public void setSpriteFromAgeReverse(SpriteSet set) {
        if (!this.removed) {
            this.setSprite(set.get(this.lifetime - this.age, this.lifetime));
        }
    }

    public ParticleRenderType getRenderType() {
        return this.settings.texture.type.toVanilla();
    }
}

