/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelector;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientInventory;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientSupplier;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.ingredient.BlockIngredient;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.ingredient.LittleIngredients;

public class LittleGuiUtils {
    public static GuiStackSelector.StackCollector getCollector(Player player) {
        if (player.isCreative()) {
            return new GuiStackSelector.CreativeCollector((GuiStackSelector.StackSelector)new LittleBlockSelector());
        }
        return new LittleBlockCollector((GuiStackSelector.StackSelector)new LittleBlockSelector());
    }

    public static class LittleBlockSelector
    extends GuiStackSelector.GuiBlockSelector {
        public boolean allow(ItemStack stack) {
            if (super.allow(stack)) {
                return LittleAction.isBlockValid(Block.byItem((Item)stack.getItem()).defaultBlockState());
            }
            return false;
        }
    }

    public static class LittleBlockCollector
    extends GuiStackSelector.InventoryCollector {
        public LittleBlockCollector(GuiStackSelector.StackSelector selector) {
            super(selector);
        }

        protected void collect(IItemHandler inventory, BlockIngredient ingredients) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.getItem() instanceof ILittleIngredientInventory) {
                    LittleIngredients ingredientsInventory = ((ILittleIngredientInventory)stack.getItem()).getInventory(stack);
                    if (ingredientsInventory == null || !ingredientsInventory.contains(BlockIngredient.class)) continue;
                    ingredients.add(ingredientsInventory.get(BlockIngredient.class));
                    continue;
                }
                @Nullable IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
                if (handler == null) continue;
                this.collect(handler, ingredients);
            }
        }

        public HashMapList<String, ItemStack> collect(Player player) {
            HashMapList stacks = super.collect(player);
            BlockIngredient ingredients = new BlockIngredient();
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack stack = player.getInventory().getItem(i);
                if (stack.getItem() instanceof ILittleIngredientSupplier) {
                    ((ILittleIngredientSupplier)stack.getItem()).collect((HashMapList<String, ItemStack>)stacks, stack, player);
                    continue;
                }
                if (stack.getItem() instanceof ILittleIngredientInventory) {
                    LittleIngredients inventory = ((ILittleIngredientInventory)stack.getItem()).getInventory(stack);
                    if (inventory == null || !inventory.contains(BlockIngredient.class)) continue;
                    ingredients.add(inventory.get(BlockIngredient.class));
                    continue;
                }
                IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
                if (handler == null) continue;
                this.collect(handler, ingredients);
            }
            ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
            for (BlockIngredientEntry ingredient : ingredients) {
                ItemStack stack = ingredient.getBlockStack();
                stack.setCount(Math.max(1, (int)ingredient.value));
                int blocks = (int)ingredient.value;
                double pixel = (ingredient.value - (double)blocks) * 4096.0;
                stack.set(DataComponents.LORE, (Object)new ItemLore(Arrays.asList(Component.literal((String)((String)(blocks > 0 ? blocks + " blocks " : "") + (String)(pixel > 0.0 ? Math.round(pixel * 100.0) / 100L + " pixel" : ""))))));
                newStacks.add(stack);
            }
            stacks.add((Object)"selector.ingredients", newStacks);
            return stacks;
        }
    }
}

