/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiActionDisplay
extends GuiControl {
    protected List<ActionMessage> messages = new ArrayList<ActionMessage>();
    private int maxActions;
    private int displayTime;
    private int fadeTime;
    private int totalTime;

    public GuiActionDisplay(String name) {
        super(name);
        this.setTimer(5, 1);
        this.setMessageCount(6);
    }

    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    public void flowX(int width, int preferred) {
        for (int i = 0; i < this.messages.size(); ++i) {
            this.messages.get(i).setDimension(width, Integer.MAX_VALUE);
        }
    }

    public void flowY(int width, int height, int preferred) {
    }

    protected int minWidth(int availableWidth) {
        return 10;
    }

    public int preferredWidth(int availableWidth) {
        int max = 0;
        for (int i = 0; i < this.messages.size(); ++i) {
            max = Math.max(max, this.messages.get(i).getTotalWidth());
        }
        return max;
    }

    protected int minHeight(int width, int availableHeight) {
        Objects.requireNonNull(Minecraft.getInstance().font);
        return 9;
    }

    public int preferredHeight(int width, int availableHeight) {
        int height = 0;
        for (int i = 0; i < this.messages.size(); ++i) {
            height += this.messages.get(i).getTotalHeight();
        }
        return height;
    }

    public GuiActionDisplay setMessageCount(int count) {
        this.maxActions = count;
        ArrayList<ActionMessage> newMessages = new ArrayList<ActionMessage>();
        for (int i = 0; i < this.messages.size() && i < count; ++i) {
            newMessages.add(this.messages.get(i));
        }
        this.messages = newMessages;
        return this;
    }

    public GuiActionDisplay setTimer(int displaySeconds, int fadeSeconds) {
        this.displayTime = displaySeconds * 1000;
        this.fadeTime = fadeSeconds * 1000;
        this.totalTime = this.displayTime + this.fadeTime;
        return this;
    }

    public void clearMessages() {
        this.messages.clear();
        this.reflow();
    }

    public void addMessage(List<Component> message) {
        this.messages.add(0, new ActionMessage(message));
        if (this.messages.size() > this.maxActions) {
            for (int i = this.maxActions; i < this.messages.size(); ++i) {
                this.messages.remove(i);
            }
        }
        this.reflow();
    }

    protected void removeMessage(int index) {
        this.messages.remove(index);
        this.reflow();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, int mouseX, int mouseY) {
        int i = 0;
        PoseStack pose = graphics.pose();
        pose.pushPose();
        while (i < this.messages.size()) {
            ActionMessage message = this.messages.get(i);
            long timer = System.currentTimeMillis() - message.timestamp;
            if (timer >= (long)this.totalTime) {
                this.removeMessage(i);
                continue;
            }
            float alpha = timer > (long)this.displayTime ? 1.0f - Math.max(0.0f, (float)(timer - (long)this.displayTime)) / (float)this.fadeTime : 1.0f;
            message.render(graphics, Math.max(0.05f, alpha));
            ++i;
            pose.translate(0.0f, (float)message.getTotalHeight(), 0.0f);
        }
        pose.popPose();
    }

    public void closed() {
    }

    public void init() {
    }

    public void tick() {
    }

    private static class ActionMessage
    extends CompiledText {
        long timestamp;

        public ActionMessage(List<Component> message) {
            super(Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.setText(message);
            this.timestamp = System.currentTimeMillis();
        }

        public void render(GuiGraphics graphics, float alpha) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            super.render(graphics);
        }
    }
}

