/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.dialog;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.parent.GuiPanel;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiCounter;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiStateButton;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.common.gui.signal.GuiSignalComponent;
import team.creative.littletiles.common.gui.signal.IConditionConfiguration;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignal;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeVirtualInput;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;

public class GuiDialogSignalVirtualInput
extends GuiLayer {
    public GuiSignalNodeVirtualInput input;
    public List<GuiSignalComponent> inputs;
    public GuiVirtualInputIndexConfiguration[] config;

    public GuiDialogSignalVirtualInput() {
        super("gui.dialog.signal.virtual_input", 230, 200);
        this.flow = GuiFlow.STACK_Y;
        this.registerEventChanged(this::changed);
    }

    public void init(List<GuiSignalComponent> inputs, GuiSignalNodeVirtualInput input) {
        this.input = input;
        this.inputs = inputs;
        super.init();
    }

    public void create() {
        if (this.input == null) {
            return;
        }
        GuiParent top = new GuiParent();
        this.add((GuiControl)top);
        top.add((GuiControl)new GuiLabel("bandwidth_label").setTitle((Component)Component.translatable((String)"gui.signal.bandwidth").append(":")));
        top.add(new GuiCounter("bandwidth", this.input.conditions.length, 0, 256).setExpandableX());
        this.add((GuiControl)new GuiScrollY("config").setExpandable());
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        bottom.addLeft((GuiControl)new GuiButton("cancel", x -> this.closeThisLayer()).setTranslate("gui.cancel"));
        bottom.addRight((GuiControl)new GuiButton("save", x -> {
            this.input.conditions = new SignalInputCondition[this.config.length];
            for (int i = 0; i < this.config.length; ++i) {
                this.input.conditions[i] = this.config[i].parse();
            }
            this.input.updateLabel();
            this.closeThisLayer();
        }).setTranslate("gui.save"));
        this.loadConditions();
    }

    public void changed(GuiControlChangedEvent event) {
        if (event.control.is("bandwidth")) {
            this.loadConditions();
        }
    }

    public void loadConditions() {
        GuiScrollY box = (GuiScrollY)this.get("config");
        box.clear();
        GuiCounter counter = (GuiCounter)this.get("bandwidth");
        int bandwidth = counter.getValue();
        this.config = new GuiVirtualInputIndexConfiguration[bandwidth];
        for (int i = 0; i < bandwidth; ++i) {
            GuiVirtualInputIndexConfiguration index = new GuiVirtualInputIndexConfiguration(i < this.input.conditions.length ? this.input.conditions[i] : new SignalInputCondition.SignalInputVirtualNumber(0), i);
            index.create(box);
            this.config[i] = index;
        }
    }

    public class GuiVirtualInputIndexConfiguration
    implements IConditionConfiguration {
        public final GuiSignalComponent output;
        public final int index;
        public SignalInputCondition condition;
        public GuiPanel panel;

        public GuiVirtualInputIndexConfiguration(SignalInputCondition condition, int index) {
            this.output = new GuiSignalComponent("" + index, "" + index, 1, SignalComponentType.OUTPUT, false, index);
            this.index = index;
            this.condition = condition;
        }

        public void create(GuiScrollY box) {
            this.panel = new GuiPanel("" + this.index, (GuiFlow)GuiFlow.STACK_X);
            this.panel.valign = VAlign.CENTER;
            box.add(this.panel.setExpandableX());
            this.panel.registerEventChanged(x -> {
                if (x.control.is("type")) {
                    this.update();
                }
            });
            this.panel.add((GuiControl)new GuiLabel("label").setTitle((Component)Component.literal((String)(this.index + ": " + (this.condition != null ? this.condition.write() : "0")))));
            int state = 0;
            SignalInputCondition signalInputCondition = this.condition;
            if (signalInputCondition instanceof SignalInputCondition.SignalInputVirtualNumber) {
                SignalInputCondition.SignalInputVirtualNumber virtual = (SignalInputCondition.SignalInputVirtualNumber)signalInputCondition;
                state = virtual.number == 1 ? 1 : 0;
            } else {
                state = 2;
            }
            this.panel.add((GuiControl)new GuiStateButton("type", state, (IComponentMap)new TextMapBuilder().addComponent((Object)0, (Component)Component.translatable((String)"gui.false")).addComponent((Object)1, (Component)Component.translatable((String)"gui.true")).addComponent((Object)2, (Component)Component.translatable((String)"gui.signal.equation"))));
            this.panel.add((GuiControl)new GuiButton("edit", x -> ((GuiDialogSignal)LittleTilesGuiRegistry.SIGNAL_DIALOG.open(GuiDialogSignalVirtualInput.this.getIntegratedParent(), new CompoundTag())).init(GuiDialogSignalVirtualInput.this.inputs, this)).setTranslate("gui.edit"));
            this.update();
        }

        @Override
        public void update() {
            GuiLabel label = (GuiLabel)this.panel.get("label");
            GuiStateButton type = (GuiStateButton)this.panel.get("type");
            GuiButton edit = (GuiButton)this.panel.get("edit");
            label.setTitle((Component)Component.literal((String)(this.index + ": " + this.parse().write())));
            edit.setEnabled((Integer)type.selected() == 2);
        }

        public SignalInputCondition parse() {
            GuiStateButton type = (GuiStateButton)this.panel.get("type");
            if ((Integer)type.selected() == 0) {
                return new SignalInputCondition.SignalInputVirtualNumber(0);
            }
            if ((Integer)type.selected() == 1) {
                return new SignalInputCondition.SignalInputVirtualNumber(1);
            }
            if (this.condition != null) {
                return this.condition;
            }
            return new SignalInputCondition.SignalInputVirtualNumber(0);
        }

        @Override
        public GuiSignalComponent getOutput() {
            return this.output;
        }

        @Override
        public SignalInputCondition getCondition() {
            return this.condition;
        }

        @Override
        public void setCondition(SignalInputCondition condition) {
            this.condition = condition;
        }

        @Override
        public boolean hasModeConfiguration() {
            return false;
        }

        @Override
        public SignalMode.GuiSignalModeConfiguration getModeConfiguration() {
            return null;
        }

        @Override
        public void setModeConfiguration(SignalMode.GuiSignalModeConfiguration config) {
        }
    }
}

