/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.location;

import java.util.Arrays;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.MissingAnimationException;

public class StructureLocation {
    public final BlockPos pos;
    public final int index;
    public final UUID levelUUID;

    public StructureLocation(BlockPos pos, int index, UUID world) {
        this.pos = pos;
        this.index = index;
        this.levelUUID = world;
    }

    public StructureLocation(Level level, BlockPos pos, int index) {
        this.pos = pos;
        this.index = index;
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            this.levelUUID = sub.getHolder().getUUID();
        } else {
            this.levelUUID = null;
        }
    }

    public StructureLocation(LittleStructure structure) {
        this(structure.getStructureLevel(), structure.getStructurePos(), structure.getIndex());
    }

    public StructureLocation(CompoundTag nbt) {
        int[] posArray = nbt.getIntArray("pos");
        if (posArray.length != 3) {
            throw new IllegalArgumentException("Invalid pos array length " + Arrays.toString(posArray));
        }
        this.pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        this.index = nbt.getInt("index");
        this.levelUUID = nbt.contains("world") ? UUID.fromString(nbt.getString("world")) : null;
    }

    public CompoundTag write(CompoundTag nbt) {
        nbt.putIntArray("pos", new int[]{this.pos.getX(), this.pos.getY(), this.pos.getZ()});
        nbt.putInt("index", this.index);
        if (this.levelUUID != null) {
            nbt.putString("world", this.levelUUID.toString());
        }
        return nbt;
    }

    public LittleStructure find(LevelAccessor level) throws LittleActionException {
        BlockEntity be;
        if (this.levelUUID != null) {
            LittleEntity entity = LittleTiles.ANIMATION_HANDLERS.find(level.isClientSide(), this.levelUUID);
            if (entity == null) {
                throw new MissingAnimationException(this.levelUUID);
            }
            level = entity.getSubLevel();
        }
        if ((be = level.getBlockEntity(this.pos)) instanceof BETiles) {
            BETiles tiles = (BETiles)be;
            IStructureParentCollection structure = tiles.getStructure(this.index);
            if (structure != null) {
                return structure.getStructure();
            }
            throw new LittleActionException.StructureNotFoundException();
        }
        throw new LittleActionException.BlockEntityNotFoundException();
    }
}

